/* A Bison parser, made by GNU Bison 2.3.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.3"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     TOK_INT = 258,
     TOK_REAL = 259,
     TOK_CHR = 260,
     TOK_STR = 261,
     TOK_BOOL = 262,
     TOK_ID = 263,
     TOK_COMMENT = 264,
     TOK_ERROR = 265,
     TOK_ROP = 266,
     TOK_ACTION = 267,
     KWD_STRUCTURE = 268,
     KWD_MATCHING = 269,
     KWD_FIELD = 270,
     KWD_TYPE = 271,
     KWD_LABEL = 272,
     KWD_START = 273,
     KWD_LENGTH = 274,
     KWD_MIN = 275,
     KWD_MAX = 276,
     KWD_TSP = 277,
     KWD_EQU = 278,
     KWD_ENC = 279,
     KWD_RESULT = 280,
     KWD_PID = 281,
     KWD_UPDATE = 282,
     KWD_NOTIFICATION = 283,
     KWD_NIL = 284,
     KWD_GEN = 285,
     KWD_GET = 286,
     KWD_MESSAGE = 287,
     KWD_TEST = 288,
     KWD_PROLOGUE = 289,
     KWD_EPILOGUE = 290,
     KWD_SURE = 291,
     KWD_EXACT = 292,
     KWD_KEY = 293,
     KWD_OPTIONAL = 294,
     KWD_INPUT = 295,
     SYM_INT = 296,
     SYM_FUNCTION = 297,
     SYM_VARIABLE = 298,
     SYM_RULE = 299,
     SYM_SYMBOL = 300,
     TOK_ARROW = 301,
     UNARYMINUS = 302,
     POWER = 303,
     KWD_OR = 304,
     KWD_AND = 305,
     KWD_NOT = 306
   };
#endif
/* Tokens.  */
#define TOK_INT 258
#define TOK_REAL 259
#define TOK_CHR 260
#define TOK_STR 261
#define TOK_BOOL 262
#define TOK_ID 263
#define TOK_COMMENT 264
#define TOK_ERROR 265
#define TOK_ROP 266
#define TOK_ACTION 267
#define KWD_STRUCTURE 268
#define KWD_MATCHING 269
#define KWD_FIELD 270
#define KWD_TYPE 271
#define KWD_LABEL 272
#define KWD_START 273
#define KWD_LENGTH 274
#define KWD_MIN 275
#define KWD_MAX 276
#define KWD_TSP 277
#define KWD_EQU 278
#define KWD_ENC 279
#define KWD_RESULT 280
#define KWD_PID 281
#define KWD_UPDATE 282
#define KWD_NOTIFICATION 283
#define KWD_NIL 284
#define KWD_GEN 285
#define KWD_GET 286
#define KWD_MESSAGE 287
#define KWD_TEST 288
#define KWD_PROLOGUE 289
#define KWD_EPILOGUE 290
#define KWD_SURE 291
#define KWD_EXACT 292
#define KWD_KEY 293
#define KWD_OPTIONAL 294
#define KWD_INPUT 295
#define SYM_INT 296
#define SYM_FUNCTION 297
#define SYM_VARIABLE 298
#define SYM_RULE 299
#define SYM_SYMBOL 300
#define TOK_ARROW 301
#define UNARYMINUS 302
#define POWER 303
#define KWD_OR 304
#define KWD_AND 305
#define KWD_NOT 306




/* Copy the first part of user declarations.  */
#line 5 "psx-spi-psr.y"


/******************************************************************************/
/* Interface                                                                  */
/******************************************************************************/

#include "psx.h"

/**************************************/
/* Crash Configuration                */
/**************************************/

#define YYSTACK_USE_ALLOCA 0
#define YYINITDEPTH 20

/**************************************/
/* Interface Definitions              */
/**************************************/

typedef struct
{
 CCI_TOKEN   tok;
 FSP_ITM     fld;
 RSP_ITM     rsl;
 PSP_ITM     sts;
} SPC_PSR_TOKEN;

#define YYDEBUG 1
//#define YYSTYPE CCI_TOKEN
#define YYSTYPE SPC_PSR_TOKEN

static PSX_SPI * spi = NULL;

/******************************************************************************/
/* Private                                                                    */
/******************************************************************************/

BOOL spi_psr_cfg (PSX_SPI * s)
{
 spi = s;

 return (TRUE);
}

/******************************************************************************/

static BOOL sch_fld_pass (FMT_ITM * f,SPC_PSR_TOKEN * t)
{
 if (f == NULL || t == NULL)
  return (FALSE);

 switch (t -> tok.idx)
 {
  case FSP_ITM_SYM:	strcpy (f -> sym,t -> tok.txt);	break;
  case FSP_ITM_DTP:	f -> dtp = t -> tok.num;	break;
  case FSP_ITM_LBL:	strcpy (f -> lbl,t -> tok.txt);	break;
  case FSP_ITM_POS:	f -> pos = t -> tok.num;	break;
  case FSP_ITM_LEN:	f -> len = t -> tok.num;	break;
  case FSP_ITM_MIN:	f -> min = t -> tok.num;	break;
  case FSP_ITM_MAX:	f -> max = t -> tok.num;	break;
  case FSP_ITM_TFM:	f -> tfm = t -> tok.num;	break;
  case FSP_ITM_EQU:	f -> equ = t -> tok.num;	break;
  case FSP_ITM_CTT:	f -> ctt = t -> tok.num;	break;

  default:
   return (FALSE);
 }

 return (TRUE);
}

/******************************************************************************/

static BOOL sch_rsl_pass (RSP_ITM * r,SPC_PSR_TOKEN * t)
{
 if (r == NULL || t == NULL)
  return (FALSE);

 switch (t -> tok.idx)
 {
  case RSP_ITM_PRM:	r -> prm = t -> tok.itg;	break;
  case RSP_ITM_RUM:	r -> rum = t -> tok.itg;	break;
  case RSP_ITM_MSG:	strcpy (r -> msg,t -> tok.txt);	break;
  case RSP_ITM_NOT:	strcpy (r -> not,t -> tok.txt); break;

  default:
   return (FALSE);
 }

 return (TRUE);
}

/******************************************************************************/

static BOOL sch_sts_pass (PSP_ITM * s,SPC_PSR_TOKEN * t)
{
 if (s == NULL || t == NULL)
  return (FALSE);

 switch (t -> tok.idx)
 {
  case PSP_ITM_STT:	s -> pro.stt = t -> tok.itg;	break;
  case PSP_ITM_MTM:	s -> pro.mtm |= t -> tok.itg;	break;
  case PSP_ITM_TGT_0:	strcpy (s -> epi.tgt_0.sym,t -> tok.txt);	break;
  case PSP_ITM_TGT_1:	strcpy (s -> epi.tgt_1.sym,t -> tok.txt);	break;
  case PSP_ITM_TGT_M:	strcpy (s -> epi.tgt_m.sym,t -> tok.txt);	break;

  default:
   return (FALSE);
 }

 return (TRUE);
}

/******************************************************************************/

static BOOL sch_sts_resolve_s (PSX_SPI * spi,IDX idx,PSX_STR sym,IDX * tgt)
{
 IDX i;

 *tgt = IDX_NIL;

 for (i = 0;i < spi -> psp -> n;i++)
 {
  if (strcmp (spi -> psp -> itm [i].sym,sym) == 0)
   if (*tgt == IDX_NIL)
   {
    *tgt = i;
   }
   else
   {
    cci_error ("multiple test targets '%s' for test '%s'",sym,spi -> psp -> itm [idx].sym);
    return (FALSE);
   }
 }

 if (*tgt == IDX_NIL)
  return (FALSE);

 return (TRUE);
}

/******************************************************************************/

static BOOL sch_sts_resolve_r (PSX_SPI * spi,IDX idx,PSX_STR sym,IDX * tgt)
{
 IDX i;

 *tgt = IDX_NIL;

 for (i = 0;i < spi -> rsp -> n;i++)
 {
  if (strcmp (spi -> rsp -> itm [i].sym,sym) == 0)
   if (*tgt == IDX_NIL)
   {
    *tgt = i;
   }
   else
   {
    cci_error ("multiple result targets '%s' for test '%s'",sym,spi -> psp -> itm [idx].sym);
    return (FALSE);
   }
 }

 if (*tgt == IDX_NIL)
  return (FALSE);

 return (TRUE);
}

/******************************************************************************/
/* syn: resolve target */

static BOOL sch_sts_resolve_t (PSX_SPI * spi,IDX idx,PSP_TGT * tgt)
{
 BOOL rs,rr;
 IDX ts,tr;

 if (str_isnil (tgt -> sym))
 {
  cci_error ("empty target in test '%s'\n",spi -> psp -> itm [idx].sym);
  return (FALSE);
 }

 rs = sch_sts_resolve_s (spi,idx,tgt -> sym,&ts);
 rr = sch_sts_resolve_r (spi,idx,tgt -> sym,&tr);

 if (rs)
 {
  if (rr)
  {
   cci_error ("ambiguous target '%s' in test '%s'",tgt -> sym,spi -> psp -> itm [idx].sym);
   return (FALSE);
  }
  else
  {
   tgt -> sdt = SDT_STS;
   tgt -> idx = ts;
  }
 }
 else
 {
  if (rr)
  {
   tgt -> sdt = SDT_RSL;
   tgt -> idx = tr;
  }
  else
  {
   cci_error ("unresolved target '%s' in test '%s'",tgt -> sym,spi -> psp -> itm [idx].sym);
   return (FALSE);
  }
 }

 return (TRUE);
}

/******************************************************************************/

static BOOL sch_sts_resolve (PSX_SPI * spi)
{
 IDX i,j;

 for (i = 0;i < spi -> psp -> n;i++)
 {
  if (!sch_sts_resolve_t (spi,i,&spi -> psp -> itm [i].epi.tgt_0))
  {
   cci_error ("unresolved target '%s' in test '%s'",spi -> psp -> itm [i].epi.tgt_0.sym,spi -> psp -> itm [i].sym);
   return (FALSE);
  }

  if (!sch_sts_resolve_t (spi,i,&spi -> psp -> itm [i].epi.tgt_1))
  {
   cci_error ("unresolved target '%s' in test '%s'",spi -> psp -> itm [i].epi.tgt_1.sym,spi -> psp -> itm [i].sym);
   return (FALSE);
  }

  if (spi -> psp -> itm [i].pro.stt == STT_QUERY)
  {
   if (!sch_sts_resolve_t (spi,i,&spi -> psp -> itm [i].epi.tgt_m))
   {
    cci_error ("unresolved target '%s' in test '%s'",spi -> psp -> itm [i].epi.tgt_m.sym,spi -> psp -> itm [i].sym);
    return (FALSE);
   }
  }
 }

 return (TRUE);
}

/******************************************************************************/



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif

#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef int YYSTYPE;
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 216 of yacc.c.  */
#line 462 "psx-spi-psr.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int i)
#else
static int
YYID (i)
    int i;
#endif
{
  return i;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  8
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   146

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  68
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  22
/* YYNRULES -- Number of rules.  */
#define YYNRULES  57
/* YYNRULES -- Number of states.  */
#define YYNSTATES  122

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   306

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,    56,    51,     2,
       2,     2,    54,    47,     2,    48,     2,    55,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    67,     2,
      52,    65,    53,    66,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    49,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    63,    50,    64,    57,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    58,    59,    60,    61,    62
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint8 yyprhs[] =
{
       0,     0,     3,     7,     9,    10,    12,    15,    17,    23,
      26,    28,    32,    36,    40,    44,    48,    52,    56,    60,
      64,    68,    69,    71,    74,    76,    82,    85,    87,    91,
      95,    99,   103,   107,   108,   110,   113,   115,   122,   129,
     134,   141,   146,   149,   151,   154,   156,   160,   164,   168,
     172,   176,   180,   184,   188,   192,   196,   199
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int8 yyrhs[] =
{
      69,     0,    -1,    70,    75,    80,    -1,     8,    -1,    -1,
      71,    -1,    72,    71,    -1,    72,    -1,    15,     8,    63,
      73,    64,    -1,    74,    73,    -1,    74,    -1,    16,    65,
       8,    -1,    17,    65,     6,    -1,    18,    65,     3,    -1,
      19,    65,     3,    -1,    20,    65,     3,    -1,    21,    65,
       3,    -1,    22,    65,     6,    -1,    23,    65,     6,    -1,
      24,    65,     8,    -1,    24,    65,    48,    -1,    -1,    76,
      -1,    77,    76,    -1,    77,    -1,    25,     8,    63,    78,
      64,    -1,    79,    78,    -1,    79,    -1,    26,    65,     3,
      -1,    26,    65,    54,    -1,    27,    65,     3,    -1,    32,
      65,    89,    -1,    28,    65,    89,    -1,    -1,    81,    -1,
      82,    81,    -1,    82,    -1,    33,     8,    63,    83,    84,
      64,    -1,    33,     3,    63,    83,    84,    64,    -1,    34,
      63,    85,    64,    -1,    34,    63,    40,    36,    66,    64,
      -1,    35,    63,    86,    64,    -1,    87,    85,    -1,    87,
      -1,    88,    86,    -1,    88,    -1,    36,    65,     3,    -1,
      36,    65,    54,    -1,    37,    65,     3,    -1,    37,    65,
      48,    -1,    38,    65,     3,    -1,    39,    65,     3,    -1,
       3,    67,     8,    -1,     3,    67,     3,    -1,    54,    67,
       8,    -1,    54,    67,     3,    -1,     6,    89,    -1,     6,
      -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   378,   378,   379,   407,   408,   413,   414,   419,   432,
     437,   446,   457,   463,   469,   475,   481,   487,   498,   507,
     518,   535,   536,   541,   542,   547,   560,   565,   574,   586,
     592,   604,   610,   623,   624,   635,   636,   641,   653,   666,
     673,   681,   687,   692,   699,   704,   711,   723,   729,   740,
     746,   758,   770,   790,   810,   816,   828,   834
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "TOK_INT", "TOK_REAL", "TOK_CHR",
  "TOK_STR", "TOK_BOOL", "TOK_ID", "TOK_COMMENT", "TOK_ERROR", "TOK_ROP",
  "TOK_ACTION", "KWD_STRUCTURE", "KWD_MATCHING", "KWD_FIELD", "KWD_TYPE",
  "KWD_LABEL", "KWD_START", "KWD_LENGTH", "KWD_MIN", "KWD_MAX", "KWD_TSP",
  "KWD_EQU", "KWD_ENC", "KWD_RESULT", "KWD_PID", "KWD_UPDATE",
  "KWD_NOTIFICATION", "KWD_NIL", "KWD_GEN", "KWD_GET", "KWD_MESSAGE",
  "KWD_TEST", "KWD_PROLOGUE", "KWD_EPILOGUE", "KWD_SURE", "KWD_EXACT",
  "KWD_KEY", "KWD_OPTIONAL", "KWD_INPUT", "SYM_INT", "SYM_FUNCTION",
  "SYM_VARIABLE", "SYM_RULE", "SYM_SYMBOL", "TOK_ARROW", "'+'", "'-'",
  "'^'", "'|'", "'&'", "'<'", "'>'", "'*'", "'/'", "'%'", "'~'",
  "UNARYMINUS", "POWER", "KWD_OR", "KWD_AND", "KWD_NOT", "'{'", "'}'",
  "'='", "'?'", "':'", "$accept", "input", "fsp", "fsp_lst", "fsp_itm",
  "fld_lst", "fld_itm", "rsp", "rsp_lst", "rsp_itm", "rsl_lst", "rsl_itm",
  "psp", "psp_lst", "psp_itm", "tst_pro", "tst_epi", "tst_pro_lst",
  "tst_epi_lst", "tst_pro_itm", "tst_epi_itm", "stl", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,    43,    45,    94,
     124,    38,    60,    62,    42,    47,    37,   126,   302,   303,
     304,   305,   306,   123,   125,    61,    63,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    68,    69,    69,    70,    70,    71,    71,    72,    73,
      73,    74,    74,    74,    74,    74,    74,    74,    74,    74,
      74,    75,    75,    76,    76,    77,    78,    78,    79,    79,
      79,    79,    79,    80,    80,    81,    81,    82,    82,    83,
      83,    84,    85,    85,    86,    86,    87,    87,    87,    87,
      87,    87,    88,    88,    88,    88,    89,    89
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     3,     1,     0,     1,     2,     1,     5,     2,
       1,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     0,     1,     2,     1,     5,     2,     1,     3,     3,
       3,     3,     3,     0,     1,     2,     1,     6,     6,     4,
       6,     4,     2,     1,     2,     1,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     2,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       4,     3,     0,     0,    21,     5,     7,     0,     1,     0,
      33,    22,    24,     6,     0,     0,     0,     2,    34,    36,
      23,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    10,     0,     0,     0,    35,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     8,     9,     0,     0,     0,
       0,     0,    27,     0,     0,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,     0,     0,     0,     0,    25,
      26,     0,     0,     0,    28,    29,    30,    57,    32,    31,
       0,     0,     0,     0,    56,     0,     0,     0,     0,     0,
       0,    43,     0,    38,    37,     0,     0,     0,     0,     0,
      39,    42,     0,     0,     0,    45,    46,    47,    48,    49,
      50,    51,     0,     0,     0,    41,    44,    40,    53,    52,
      55,    54
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
      -1,     3,     4,     5,     6,    30,    31,    10,    11,    12,
      51,    52,    17,    18,    19,    72,    82,    90,   104,    91,
     105,    78
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -64
static const yytype_int8 yypact[] =
{
      18,   -64,     5,     9,    10,   -64,    19,   -27,   -64,    29,
      12,   -64,    10,   -64,     1,   -17,     7,   -64,   -64,    12,
     -64,   -22,   -18,   -16,   -15,   -11,   -10,    -9,    -7,    -6,
       3,     1,   -20,     6,    11,   -64,    49,    54,    58,    59,
      60,    61,    62,    64,    -4,   -64,   -64,    13,    14,    15,
      16,    20,   -20,    31,    31,   -64,   -64,   -64,   -64,   -64,
     -64,   -64,   -64,   -64,   -64,    -3,    63,    65,    65,   -64,
     -64,    22,    37,    37,   -64,   -64,   -64,    65,   -64,   -64,
       2,    23,    25,    26,   -64,    17,    27,    28,    30,    39,
      32,    -8,    -2,   -64,   -64,    -1,     0,    70,    73,    21,
     -64,   -64,    33,    34,    35,    -2,   -64,   -64,   -64,   -64,
     -64,   -64,    38,     8,    24,   -64,   -64,   -64,   -64,   -64,
     -64,   -64
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -64,   -64,   -64,    71,   -64,    52,   -64,   -64,    76,   -64,
      42,   -64,   -64,    72,   -64,    43,    36,    40,    41,   -64,
     -64,   -63
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const yytype_uint8 yytable[] =
{
      74,   102,   106,   108,    63,    79,    47,    48,    49,     8,
      33,   118,    50,     7,    84,    34,   119,    21,    22,    23,
      24,    25,    26,    27,    28,    29,     1,   120,    85,    86,
      87,    88,   121,     2,     2,     9,    14,    15,    85,    86,
      87,    88,    89,    36,    64,    16,    32,    37,   109,    38,
      39,    75,   103,   107,    40,    41,    42,    55,    43,    44,
      56,    57,    58,    59,    60,    71,    76,    45,    61,    53,
      62,    77,    81,   110,    54,    99,   111,    13,    65,    66,
      67,    68,    95,    46,    69,    80,    92,   112,    20,    93,
      94,    35,    96,    97,    70,    98,   100,    73,     0,   115,
     113,   114,   117,     0,     0,     0,     0,     0,     0,    83,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   101,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   116
};

static const yytype_int8 yycheck[] =
{
       3,     3,     3,     3,     8,    68,    26,    27,    28,     0,
       3,     3,    32,     8,    77,     8,     8,    16,    17,    18,
      19,    20,    21,    22,    23,    24,     8,     3,    36,    37,
      38,    39,     8,    15,    15,    25,    63,     8,    36,    37,
      38,    39,    40,    65,    48,    33,    63,    65,    48,    65,
      65,    54,    54,    54,    65,    65,    65,     8,    65,    65,
       6,     3,     3,     3,     3,    34,     3,    64,     6,    63,
       6,     6,    35,     3,    63,    36,     3,     6,    65,    65,
      65,    65,    65,    31,    64,    63,    63,    66,    12,    64,
      64,    19,    65,    65,    52,    65,    64,    54,    -1,    64,
      67,    67,    64,    -1,    -1,    -1,    -1,    -1,    -1,    73,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   105
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     8,    15,    69,    70,    71,    72,     8,     0,    25,
      75,    76,    77,    71,    63,     8,    33,    80,    81,    82,
      76,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      73,    74,    63,     3,     8,    81,    65,    65,    65,    65,
      65,    65,    65,    65,    65,    64,    73,    26,    27,    28,
      32,    78,    79,    63,    63,     8,     6,     3,     3,     3,
       3,     6,     6,     8,    48,    65,    65,    65,    65,    64,
      78,    34,    83,    83,     3,    54,     3,     6,    89,    89,
      63,    35,    84,    84,    89,    36,    37,    38,    39,    40,
      85,    87,    63,    64,    64,    65,    65,    65,    65,    36,
      64,    85,     3,    54,    86,    88,     3,    54,     3,    48,
       3,     3,    66,    67,    67,    64,    86,    64,     3,     8,
       3,     8
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *bottom, yytype_int16 *top)
#else
static void
yy_stack_print (bottom, top)
    yytype_int16 *bottom;
    yytype_int16 *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      fprintf (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       );
      fprintf (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;
#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  yytype_int16 yyssa[YYINITDEPTH];
  yytype_int16 *yyss = yyssa;
  yytype_int16 *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     look-ahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to look-ahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 3:
#line 380 "psx-spi-psr.y"
    {
                       cci_error ("syntax error at '%s'",(yyvsp[(1) - (1)]).tok.txt);
                      }
    break;

  case 8:
#line 420 "psx-spi-psr.y"
    {
                       (yyval) = (yyvsp[(4) - (5)]);
                       strcpy ((yyval).fld.sym,(yyvsp[(2) - (5)]).tok.txt);
                       if (spi -> fsp)
                        fsp_add (spi -> fsp,&(yyval).fld);
                       else
                        cci_error ("format specification not allowed here");
                      }
    break;

  case 9:
#line 433 "psx-spi-psr.y"
    {
                       memcpy (&(yyval).fld,&(yyvsp[(2) - (2)]).fld,sizeof ((yyval).fld));
                       sch_fld_pass (&(yyval).fld,&(yyvsp[(1) - (2)]));
                      }
    break;

  case 10:
#line 438 "psx-spi-psr.y"
    {
                       memset (&(yyval).fld,0,sizeof ((yyval).fld));
                       sch_fld_pass (&(yyval).fld,&(yyvsp[(1) - (1)]));
                      }
    break;

  case 11:
#line 447 "psx-spi-psr.y"
    {
                       DTP t;

                       if (!fsp_dtp_set	(&t,(yyvsp[(3) - (3)]).tok.txt))
                        cci_error ("invalid data type");

                       (yyval).tok.idx = FSP_ITM_DTP;
                       (yyval).tok.num = t;
                      }
    break;

  case 12:
#line 458 "psx-spi-psr.y"
    {
                       (yyval).tok.idx = FSP_ITM_LBL;
                       strcpy ((yyval).tok.txt,(yyvsp[(3) - (3)]).tok.txt);
                      }
    break;

  case 13:
#line 464 "psx-spi-psr.y"
    {
                       (yyval).tok.idx = FSP_ITM_POS;
                       (yyval).tok.num = (yyvsp[(3) - (3)]).tok.itg;
                      }
    break;

  case 14:
#line 470 "psx-spi-psr.y"
    {
                       (yyval).tok.idx = FSP_ITM_LEN;
                       (yyval).tok.num = (yyvsp[(3) - (3)]).tok.itg;
                      }
    break;

  case 15:
#line 476 "psx-spi-psr.y"
    {
                       (yyval).tok.idx = FSP_ITM_MIN;
                       (yyval).tok.num = (yyvsp[(3) - (3)]).tok.itg;
                      }
    break;

  case 16:
#line 482 "psx-spi-psr.y"
    {
                       (yyval).tok.idx = FSP_ITM_MAX;
                       (yyval).tok.num = (yyvsp[(3) - (3)]).tok.itg;
                      }
    break;

  case 17:
#line 488 "psx-spi-psr.y"
    {
                       TFM t;

                       if (!fsp_tfm_dec	(&t,(yyvsp[(3) - (3)]).tok.txt))
                        cci_error ("invalid transformation code");

                       (yyval).tok.idx = FSP_ITM_TFM;
                       (yyval).tok.num = t;
                      }
    break;

  case 18:
#line 499 "psx-spi-psr.y"
    {
                       EQU equ;

                       fsp_equ_dec (&equ,(yyvsp[(3) - (3)]).tok.txt);
                       (yyval).tok.idx = FSP_ITM_EQU;
                       (yyval).tok.num = equ;
                      }
    break;

  case 19:
#line 508 "psx-spi-psr.y"
    {
                       CTT ctt;

                       if (!fsp_ctt_dec	(&ctt,(yyvsp[(3) - (3)]).tok.txt))
                        cci_error ("invalid encryption type");

                       (yyval).tok.idx = FSP_ITM_CTT;
                       (yyval).tok.num = ctt;
                      }
    break;

  case 20:
#line 519 "psx-spi-psr.y"
    {
                       (yyval).tok.idx = FSP_ITM_CTT;
                       (yyval).tok.num = CTT_ZERO;
                      }
    break;

  case 25:
#line 548 "psx-spi-psr.y"
    {
                       (yyval) = (yyvsp[(4) - (5)]);
                       strcpy ((yyval).rsl.sym,(yyvsp[(2) - (5)]).tok.txt);
                       if (spi -> rsp)
                        rsp_add (spi -> rsp,&(yyval).rsl);
                       else
                        cci_error ("result specification not allowed here");
                      }
    break;

  case 26:
#line 561 "psx-spi-psr.y"
    {
                       memcpy (&(yyval).rsl,&(yyvsp[(2) - (2)]).rsl,sizeof ((yyval).rsl));
                       sch_rsl_pass (&(yyval).rsl,&(yyvsp[(1) - (2)]));
                      }
    break;

  case 27:
#line 566 "psx-spi-psr.y"
    {
                       memset (&(yyval).rsl,0,sizeof ((yyval).rsl));
                       sch_rsl_pass (&(yyval).rsl,&(yyvsp[(1) - (1)]));
                      }
    break;

  case 28:
#line 575 "psx-spi-psr.y"
    {
                       (yyval).tok.idx = RSP_ITM_PRM;
                       switch ((yyvsp[(3) - (3)]).tok.itg)
                       {
                        case 0:		(yyval).tok.itg = PRM_ZERO;				break;
                        case 1:		(yyval).tok.itg = PRM_GET;				break;
                        default:	cci_error ("invalid pid retrieval mode");	break;
                       }

                      }
    break;

  case 29:
#line 587 "psx-spi-psr.y"
    {
                       (yyval).tok.idx = RSP_ITM_PRM;
                       (yyval).tok.itg = PRM_GEN;
                      }
    break;

  case 30:
#line 593 "psx-spi-psr.y"
    {
                       (yyval).tok.idx = RSP_ITM_RUM;

                       switch ((yyvsp[(3) - (3)]).tok.itg)
                       {
                        case 0:		(yyval).tok.itg = RUM_ZERO;				break;
                        case 1:		(yyval).tok.itg = RUM_UPDATE;			break;
                        default:	cci_error ("invalid record update mode");	break;
                       }
                      }
    break;

  case 31:
#line 605 "psx-spi-psr.y"
    {
                       (yyval).tok.idx = RSP_ITM_MSG;
                       strcpy ((yyval).tok.txt,(yyvsp[(3) - (3)]).tok.txt);
                      }
    break;

  case 32:
#line 611 "psx-spi-psr.y"
    {
                       (yyval).tok.idx = RSP_ITM_NOT;
                       strcpy ((yyval).tok.txt,(yyvsp[(3) - (3)]).tok.txt);
                      }
    break;

  case 34:
#line 625 "psx-spi-psr.y"
    {
                       if (!sch_sts_resolve (spi))
                       {
                        cci_error ("inconsistent schema specification");
                       }
                      }
    break;

  case 37:
#line 642 "psx-spi-psr.y"
    {
                       memset (&(yyval).sts,0,sizeof ((yyval).sts));
                       memcpy (&(yyval).sts.pro,&(yyvsp[(4) - (6)]).sts.pro,sizeof ((yyval).sts.pro));
                       memcpy (&(yyval).sts.epi,&(yyvsp[(5) - (6)]).sts.epi,sizeof ((yyval).sts.epi));
                       strcpy ((yyval).sts.sym,(yyvsp[(2) - (6)]).tok.txt);
                       if (spi -> psp)
                        psp_add (spi -> psp,&(yyval).sts);
                       else
                        cci_error ("procedure specification not allowed here");
                      }
    break;

  case 38:
#line 654 "psx-spi-psr.y"
    {
                       memset (&(yyval).sts,0,sizeof ((yyval).sts));
                       memcpy (&(yyval).sts.pro,&(yyvsp[(4) - (6)]).sts.pro,sizeof ((yyval).sts.pro));
                       memcpy (&(yyval).sts.epi,&(yyvsp[(5) - (6)]).sts.epi,sizeof ((yyval).sts.epi));
                       sprintf ((yyval).sts.sym,"%d",(yyvsp[(2) - (6)]).tok.itg);
                       if (spi -> psp)
                        psp_add (spi -> psp,&(yyval).sts);
                       else
                        cci_error ("procedure specification not allowed here");
                      }
    break;

  case 39:
#line 667 "psx-spi-psr.y"
    {
                       (yyval) = (yyvsp[(3) - (4)]);
                       (yyval).sts.pro.stt = STT_QUERY;
                       (yyval).sts.pro.mtm = (yyvsp[(3) - (4)]).sts.pro.mtm;
                      }
    break;

  case 40:
#line 674 "psx-spi-psr.y"
    {
                       memset (&(yyval).sts,0,sizeof ((yyval).sts));
                       (yyval).sts.pro.stt = STT_INPUT;
                       (yyval).sts.pro.mtm = 0x00;
                      }
    break;

  case 41:
#line 682 "psx-spi-psr.y"
    {
                       (yyval) = (yyvsp[(3) - (4)]);
                      }
    break;

  case 42:
#line 688 "psx-spi-psr.y"
    {
                       memcpy (&(yyval).sts,&(yyvsp[(2) - (2)]).sts,sizeof ((yyval).sts));
                       sch_sts_pass (&(yyval).sts,&(yyvsp[(1) - (2)]));
                      }
    break;

  case 43:
#line 693 "psx-spi-psr.y"
    {
                       memset (&(yyval).sts,0,sizeof ((yyval).sts));
                       sch_sts_pass (&(yyval).sts,&(yyvsp[(1) - (1)]));
                      }
    break;

  case 44:
#line 700 "psx-spi-psr.y"
    {
                       memcpy (&(yyval).sts,&(yyvsp[(2) - (2)]).sts,sizeof ((yyval).sts));
                       sch_sts_pass (&(yyval).sts,&(yyvsp[(1) - (2)]));
                      }
    break;

  case 45:
#line 705 "psx-spi-psr.y"
    {
                       memset (&(yyval).sts,0,sizeof ((yyval).sts));
                       sch_sts_pass (&(yyval).sts,&(yyvsp[(1) - (1)]));
                      }
    break;

  case 46:
#line 712 "psx-spi-psr.y"
    {
                       (yyval).tok.idx = PSP_ITM_MTM;

                       switch ((yyvsp[(3) - (3)]).tok.itg)
                       {
                        case 0:		(yyval).tok.itg = MTM_S0;				break;
                        case 1:		(yyval).tok.itg = MTM_S1;				break;
                        default:	cci_error ("invalid sureness specification");	break;
                       }
                      }
    break;

  case 47:
#line 724 "psx-spi-psr.y"
    {
                       (yyval).tok.idx = PSP_ITM_MTM;
                       (yyval).tok.itg = MTM_SX;
                      }
    break;

  case 48:
#line 730 "psx-spi-psr.y"
    {
                       (yyval).tok.idx = PSP_ITM_MTM;
                       switch ((yyvsp[(3) - (3)]).tok.itg)
                       {
                        case 0:		(yyval).tok.itg = MTM_X0;				break;
                        case 1:		(yyval).tok.itg = MTM_X1;				break;
                        default:	cci_error ("invalid exactness specification");	break;
                       }
                      }
    break;

  case 49:
#line 741 "psx-spi-psr.y"
    {
                       (yyval).tok.idx = PSP_ITM_MTM;
                       (yyval).tok.itg = MTM_XI;
                      }
    break;

  case 50:
#line 747 "psx-spi-psr.y"
    {
                       (yyval).tok.idx = PSP_ITM_MTM;
                       switch ((yyvsp[(3) - (3)]).tok.itg)
                       {
                        case 0:		(yyval).tok.itg = MTM_K0;				break;
                        case 1:		(yyval).tok.itg = MTM_K1;
                        break;
                        default:	cci_error ("invalid key specification");	break;
                       }
                      }
    break;

  case 51:
#line 759 "psx-spi-psr.y"
    {
                       (yyval).tok.idx = PSP_ITM_MTM;
                       switch ((yyvsp[(3) - (3)]).tok.itg)
                       {
                        case 0:		(yyval).tok.itg = MTM_O0;				break;
                        case 1:		(yyval).tok.itg = MTM_O1;				break;
                        default:	cci_error ("invalid optionality specification");	break;
                       }
                      }
    break;

  case 52:
#line 771 "psx-spi-psr.y"
    {
                       switch ((yyvsp[(1) - (3)]).tok.itg)
                       {
                        case 0:
                         (yyval).tok.idx = PSP_ITM_TGT_0;
                         strcpy ((yyval).tok.txt,(yyvsp[(3) - (3)]).tok.txt);
                         break;

                        case 1:
                         (yyval).tok.idx = PSP_ITM_TGT_1;
                         strcpy ((yyval).tok.txt,(yyvsp[(3) - (3)]).tok.txt);
                         break;

                        default:
                         cci_error ("invalid epilogue case");
                         break;
                       }
                      }
    break;

  case 53:
#line 791 "psx-spi-psr.y"
    {
                       switch ((yyvsp[(1) - (3)]).tok.itg)
                       {
                        case 0:
                         (yyval).tok.idx = PSP_ITM_TGT_0;
                         sprintf ((yyval).tok.txt,"%d",(yyvsp[(3) - (3)]).tok.itg);
                         break;

                        case 1:
                         (yyval).tok.idx = PSP_ITM_TGT_1;
                         sprintf ((yyval).tok.txt,"%d",(yyvsp[(3) - (3)]).tok.itg);
                         break;

                        default:
                         cci_error ("invalid epilogue case");
                         break;
                       }
                      }
    break;

  case 54:
#line 811 "psx-spi-psr.y"
    {
                       (yyval).tok.idx = PSP_ITM_TGT_M;
                       strcpy ((yyval).tok.txt,(yyvsp[(3) - (3)]).tok.txt);
                      }
    break;

  case 55:
#line 817 "psx-spi-psr.y"
    {
                       (yyval).tok.idx = PSP_ITM_TGT_M;
                       sprintf ((yyval).tok.txt,"%d",(yyvsp[(3) - (3)]).tok.itg);
                      }
    break;

  case 56:
#line 829 "psx-spi-psr.y"
    {
                       (yyval).tok.idx = TOK_STR;
                       strcpy ((yyval).tok.txt,(yyvsp[(1) - (2)]).tok.txt);
                       strcat ((yyval).tok.txt,(yyvsp[(2) - (2)]).tok.txt);
                      }
    break;

  case 57:
#line 835 "psx-spi-psr.y"
    {
                       (yyval).tok.idx = TOK_STR;
                       strcpy ((yyval).tok.txt,(yyvsp[(1) - (1)]).tok.txt);
                      }
    break;


/* Line 1267 of yacc.c.  */
#line 2228 "psx-spi-psr.c"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (yymsg);
	  }
	else
	  {
	    yyerror (YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEOF && yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}


#line 842 "psx-spi-psr.y"


/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

static void psr_error (char * fmt,...)
{
 static char s [300];
 long l;
 va_list arg;

 va_start (arg,fmt);
 vsprintf (s,fmt,arg);
 va_end (arg);
 //l = vli_get_line ();

 printf (" ERROR [%04lu]: %s\n",l,s);

 // fprintf (stdout,"scn.dic = %P\n",scn.dic); getch ();
}

/*extern */ int yydebug;

CCI_YACC spc_yacc =
{
 &yydebug,
 (CCI_TOKEN *)&yylval,
 yyparse
};

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/





