/******************************************************************************/
/* tcc-scn.l                                                           7/1998 */
/******************************************************************************/

%{

/******************************************************************************/
/* Interface                                                                  */
/******************************************************************************/

#include "psx.h"
#include "psx-spi-psr.h"

%}

/******************************************************************************/
/* Lexical Analyzer                                                           */
/******************************************************************************/

delim      [ \t\r]
ws         {delim}+
DEC        [0-9][0-9]*
OCT        0o[0-9]*
HEX        0x[0-9A-Fa-f]+
BIN        0b[0-1]*
ID         [a-zA-Z_][a-zA-Z0-9_]*
/* STRING     \"[^\n"]+\" */
STRING     \"[^\n"]*\"

/******************************************************************************/
/* Rules                                                                      */
/******************************************************************************/

%%

{ws}                { }

"\n"                { cci_lex (LTP_NL,0);  }

"//"                { cci_lex (LTP_CMT,0); }
"/*"                { cci_lex (LTP_CMT,0); }

"'"                 { return (cci_lex (LTP_CHR,TOK_CHR)); }

"("                 { return ('('); }
")"                 { return (')'); }
"="                 { return ('='); }
";"                 { return (';'); }
","                 { return (','); }
"+"                 { return ('+'); }
"-"                 { return ('-'); }
"*"                 { return ('*'); }
"/"                 { return ('/'); }
"%"                 { return ('%'); }
"&"                 { return ('&'); }
"|"                 { return ('|'); }
"^"                 { return ('^'); }
"~"                 { return ('~'); }
"{"                 { return ('{'); }
"}"                 { return ('}'); }
":"                 { return (':'); }
"."                 { return ('.'); }

"=="                { return (cci_lex (LTP_ROP,TOK_ROP)); }
"!="                { return (cci_lex (LTP_ROP,TOK_ROP)); }
"<"                 { return (cci_lex (LTP_ROP,TOK_ROP)); }
"<="                { return (cci_lex (LTP_ROP,TOK_ROP)); }
">"                 { return (cci_lex (LTP_ROP,TOK_ROP)); }
">="                { return (cci_lex (LTP_ROP,TOK_ROP)); }

"->"                { return (TOK_ARROW); }

"?"                 { return ('?'); }

{DEC}               { return (cci_lex (LTP_DEC,TOK_INT)); }
{HEX}               { return (cci_lex (LTP_HEX,TOK_INT)); }
{OCT}               { return (cci_lex (LTP_OCT,TOK_INT)); }
{BIN}               { return (cci_lex (LTP_BIN,TOK_INT)); }
{STRING}            { return (cci_lex (LTP_STR,TOK_STR)); }

"TRUE"              { return (TOK_BOOL);          }
"FALSE"             { return (TOK_BOOL);          }

"[Structure]"       { return (KWD_STRUCTURE);     }
"[Matching]"        { return (KWD_MATCHING);      }

"Field"             { return (KWD_FIELD);         }
"type"              { return (KWD_TYPE);          }
"label"             { return (KWD_LABEL);         }
"start"             { return (KWD_START);         }
"length"            { return (KWD_LENGTH);        }
"min"               { return (KWD_MIN);           }
"max"               { return (KWD_MAX);           }
"tsp"               { return (KWD_TSP);           }
"transformation"    { return (KWD_TSP);           }
"equ"               { return (KWD_EQU);           }
"enc"               { return (KWD_ENC);           }

"Result"            { return (KWD_RESULT);        }
"pid"               { return (KWD_PID);           }
"update"            { return (KWD_UPDATE);        }
"notification"      { return (KWD_NOTIFICATION);  }

"message"           { return (KWD_MESSAGE);       }


"Test"              { return (KWD_TEST);             }
"Prologue"          { return (KWD_PROLOGUE);           }
"Epilogue"          { return (KWD_EPILOGUE);           }
"sure"              { return (KWD_SURE);           }
"exact"             { return (KWD_EXACT);           }
"key"               { return (KWD_KEY);           }
"optional"          { return (KWD_OPTIONAL);           }

"input"             { return (KWD_INPUT);           }


{ID}                { return (cci_lex (LTP_ID,TOK_ID));   }

.                   { yyerror ("Scanner Error!!!\n");          }

%%

/******************************************************************************/
/* Scanner                                                                    */
/******************************************************************************/

int debug;
#ifdef __cplusplus
extern int yyinput();
#else
extern int input();
#endif

/******************************************************************************/

int ssp_error (char * s)
{
 cci_error ("%s",s);
 exit (-1);
 return (-1);
}

/******************************************************************************/

int ssp_wrap ()
{
 return (1);
}

CCI_LEX spc_lex =
{
 &yyin,
 &yyout,
 &yytext,
 &debug, // yy_flex_debug,
 input, // yyinput,
 yylex,
 0,
 &cci_scnprc, //0,
 (CCI_TOKEN *) &yylval
};

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/
