/******************************************************************************/
/* psx-spi.h                                   Specification Parser Interface */
/******************************************************************************/
/** @file psx-spi.h Specification Parser Interface - Header File
 * Definitions supporting the usage of the specification parser.
 */
 
#ifndef _psx_spi_
#define _psx_spi_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"

/**************************************/
/* Specification Component            */
/**************************************/

typedef BYTE SCP;        //!< specification component

#define	SCP_ZERO	0x00
#define	SCP_FSP		0x01   //!< format specification
#define	SCP_RSP		0x02   //!< registry specification ?
#define	SCP_PSP		0x04   //!< p... specificaton

typedef struct _PSX_SPI  //!< specification parser interface
{
 PSX_FSP * fsp;
 PSX_RSP * rsp;
 PSX_PSP * psp;
} PSX_SPI;

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

LINKAGE	BOOL	spi_parse	(PSX_SPI * spi,SCP scp,PSX_STR f);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_sch_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


