/******************************************************************************/
/* psx-stk.h                                     Stack Management Interface   */
/******************************************************************************/
/** @file psx-stk.h Stack Management Interface - Header File
 * Definitions and prototypes supporting the usage of a stack datastructure
 * by psx modules.
 */
 
#ifndef _psx_stk_
#define _psx_stk_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

SYS_STRUCTURE (PSX_STK)
{
 PTR * p;         // pointer to element
 NUM   n;         // number of elements
 NUM   s;   
 NUM   esz;       // element size
};

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

LINKAGE	BOOL	stk_create	(PSX_STK ** stk);
LINKAGE	BOOL	stk_delete	(PSX_STK ** stk);

LINKAGE	BOOL	stk_push	(PSX_STK * stk,PTR ptr);
LINKAGE	BOOL	stk_pop		(PSX_STK * stk,PTR ptr);

LINKAGE	BOOL	stk_set_esz	(PSX_STK * stk,int esz);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_stk_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


