/******************************************************************************/
/* psx-stl.c                        String List Interface                     */
/******************************************************************************/
/** @file psx-stl.c String List Interface - Source code File
 * Functions providing the usage of a string list datastructure by psx modules.
 */
 
#include "psx.h"

/******************************************************************************/
/* Private                                                                    */
/******************************************************************************/
/** get length of stringlist
 * @param stl string list structure
 * @param n length of string list
 */

static BOOL stl_get_len (PSX_STL * stl,NUM * n)
{
 IDX i;

 if (stl == NULL || n == NULL)
  return (FALSE);

 *n = 0;

 for (i = 0;i < stl -> n;i++)
  *n += strlen (stl -> str [i]);

 return (TRUE);
}

/******************************************************************************/
/* Public                                                                     */
/******************************************************************************/
/** create stringlist
 * @param pointer to string list
 */

BOOL stl_create (PSX_STL ** stl)
{
 if (stl == NULL)
  return (FALSE);

 if ((*stl = (PSX_STL *) malloc (sizeof (**stl))) == NULL)
  return (FALSE);

 memset (*stl,0,sizeof (**stl));

 return (TRUE);
}

/******************************************************************************/
/** delete stringlist
 * @param stl pointer to string list
 */

BOOL stl_delete (PSX_STL ** stl)
{
 if (stl == NULL)
  return (FALSE);

 stl_clear (*stl);

 free (*stl);
 *stl = NULL;

 return (TRUE);
}

/******************************************************************************/
/** clear stringlist
 * @pram stl string list
 */

BOOL stl_clear (PSX_STL * stl)
{
 if (stl == NULL)
  return (FALSE);

 if (stl -> n > 0)
 {
  int i;

  assert (stl -> str != NULL);

  for (i = 0;i < stl -> n;i++)
  {
   if (stl -> str [i])
   {
    free (stl -> str [i]);
    stl -> str [i] = NULL;
   }
  }

  free (stl -> str);
  stl -> str = NULL;
 }

 assert (stl -> str == NULL);

 stl -> n = 0;

 return (TRUE);
}

/******************************************************************************/
/** insert string into string list
 * @param stl  target string list
 * @param src source string
 */

BOOL stl_add (PSX_STL * stl,char * src)
{
 if (!stl_ins (stl,stl -> n,src))
  return (FALSE);

 return (TRUE);
}

/******************************************************************************/
/** insert string into string list
 * @param stl string list
 * @param idx index
 * @param src source string
 */

BOOL stl_ins (PSX_STL * stl,IDX idx,char * src)
{
 int i;
 char ** t;

 if (stl == NULL || src == NULL)
  return (FALSE);

 if (idx > stl -> n)
  return (FALSE);

 if ((t = (char **) realloc (stl -> str,(stl -> n + 1) * sizeof (char *))) == NULL)
  return (FALSE);

 stl -> str = t;
 stl -> n++;

 for (i = stl -> n - 1;i > idx;i--)
  stl -> str [i] = stl -> str [i - 1];

 stl -> str [idx] = strdup (src);

 return (TRUE);
}

/******************************************************************************/
/** get string by index
 * @param stl string list
 * @param idx index of searched string in string list
 * @pram str pointer to result string
 */

BOOL stl_get (PSX_STL * stl,IDX idx,char ** str)
{
 if (stl == NULL)
  return (FALSE);

 if (idx >= stl -> n)
  return (FALSE);

 if (str)
  *str = stl -> str [idx];

 return (TRUE);
}

/******************************************************************************/
/** append stringlist to string
 * @param stl source string list
 * @param del delimiting character
 * @param str pointer to target string
 */

BOOL stl_cat (PSX_STL * stl,char * del,char ** str)
{
 NUM n,l;
 IDX i;

 if (stl == NULL || str == NULL)
  return (FALSE);

 if (del == NULL)
  del = ""; 

 if (stl -> n == 0)
 {
  *str = strdup ("");               // get new empty string
  return (TRUE);
 }

 if (!stl_get_len (stl,&n))         // get length of stringlist
  return (FALSE);

 l = strlen (del);

 n += (stl -> n - 1) * l;
 
 if ((*str = (char *) malloc ((n + 1) * sizeof (char))) == NULL)
  return (FALSE);

 strcpy (*str,"");

 for (i = 0;i < stl -> n;i++)      // append string list to string
 {
  if (i > 0)
   strcat (*str,del);              // append del to str

  strcat (*str,stl -> str [i]);    // append string list entry
 }

 return (TRUE);
}

/******************************************************************************/
/** print string list
 * @param stl string list
 */

BOOL stl_print (PSX_STL * stl)
{
 IDX i;

 if (stl == NULL)
  return (FALSE);

 printf ("STL [%p]\n\n",stl);

 for (i = 0;i < stl -> n;i++)
  printf ("> %s\n",stl -> str [i]);

 return (TRUE);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/



