/******************************************************************************/
/* psx-stl.h                             String List Interface                */
/******************************************************************************/
/** @file psx-stl.h String list Interface -  Header File
 * Definitions supporting a string list datastructure for being used by psx
 * modules.
 */
 
#ifndef _psx_stl_
#define _psx_stl_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/** Structure                                                                 */
/******************************************************************************/

/** String list.
 * Holds an array of strings and their number. Access functions are defined
 * in psx_stl.c.
 */
typedef struct _PSX_STL
{
 char ** str;           /**< pointer to strings           */
 NUM     n;             /**< number of strings            */
} PSX_STL;

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

LINKAGE	BOOL	stl_create	(PSX_STL ** stl);
LINKAGE	BOOL	stl_delete	(PSX_STL ** stl);
LINKAGE	BOOL	stl_clear	(PSX_STL * stl);
LINKAGE	BOOL	stl_add		(PSX_STL * stl,char * src);
LINKAGE	BOOL	stl_ins		(PSX_STL * stl,IDX idx,char * src);
LINKAGE	BOOL	stl_get		(PSX_STL * stl,IDX idx,char ** str);
LINKAGE	BOOL	stl_cat		(PSX_STL * stl,char * del,char ** str);
LINKAGE	BOOL	stl_print	(PSX_STL * stl);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_stl_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/





