/******************************************************************************/
/* psx-stm.h                                       Stream Interface           */
/******************************************************************************/
/** @file psx-stm.h Stream Interface - Header File
 * Definitions and prototypes supporting the usage of a stream management system.
 */
 
#ifndef _psx_stm_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

//#include <ssi.h>

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#define STP_ZERO	0
#define STP_FILE	1
#define STP_BLOCK	2

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#define STM_CMD_ZERO	0
#define STM_CMD_CREATE	1
#define STM_CMD_DELETE	2
#define STM_CMD_OPEN	3
#define STM_CMD_CLOSE	4
#define STM_CMD_READ	5
#define STM_CMD_WRITE	6
#define STM_CMD_SETPOS	7
#define STM_CMD_GETPOS	8

typedef BOOL (* SSI_STM_CTL) (PTR ctx,IDX cmd,NUM n,PTR p);
#define STM_CTL(prc) BOOL prc (PTR ctx,IDX cmd,NUM n,PTR p)

/******************************************************************************/

SYS_STRUCTURE (SSI_STM)
{
 TYPE        stp;        /* stream type              */
 PTR         ctx;        /* context                  */
 SSI_STM_CTL ctl;        /* stream control procedure */
};

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

LINKAGE	BOOL	stm_create	(SSI_STM ** stm);
LINKAGE	BOOL	stm_delete	(SSI_STM ** stm);
LINKAGE	BOOL	stm_open  	(SSI_STM ** stm,char * src);
LINKAGE	BOOL	stm_close 	(SSI_STM ** stm);
LINKAGE	BOOL	stm_link	(SSI_STM * stm,TYPE stp,PTR ctx);
LINKAGE	BOOL	stm_ctl		(SSI_STM * stm,IDX cmd,NUM n,PTR p);

LINKAGE	BOOL	stm_read	(SSI_STM * stm,PTR p,NUM n);
LINKAGE	BOOL	stm_write	(SSI_STM * stm,PTR p,NUM n);
LINKAGE	BOOL	stm_setpos	(SSI_STM * stm,IDX pos);
LINKAGE	BOOL	stm_getpos	(SSI_STM * stm,IDX * pos);

LINKAGE	BOOL	stm_getctx	(SSI_STM * stm,TYPE stp,PTR pctx);

LINKAGE	BOOL	stm_readl	(SSI_STM * stm,PTR p,NUM n);


/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_stm_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/



