/******************************************************************************/
/* psx-stm.inl                                               Stream Interface */
/******************************************************************************/
/** @file psx-stm.inl Stream Interface - Inline Source Code File
 * Functions providing the usage of the stream interface.
 */
 
/******************************************************************************/
/* ctx: nil                                                                   */
/******************************************************************************/

/******************************************************************************/
/* ctx: file                                                                  */
/******************************************************************************/


/****
* #define STM_CTL(prc) BOOL prc (PTR ctx,IDX cmd,NUM n,PTR p)
*/

/**
 */

static STM_CTL (stm_ctl_f)  // static BOOL stm_ctl_f(PTR ctx, IDX cmd, NUM n, PTR p)
{
 SSI_FILE * f = (SSI_FILE *) ctx;

 if (f == NULL && cmd != STM_CMD_CREATE)
  return (FALSE);

 switch (cmd)
 {
  case STM_CMD_CREATE:
  {
   SSI_FILE ** f = p;

   if (!fil_create (f))
    return (FALSE);
   break;
  }

  case STM_CMD_DELETE:
  {
   SSI_FILE ** f = p;

   if (!fil_delete (f))
    return (FALSE);
   break;
  }

  case STM_CMD_OPEN:
   if (!fil_open (f,p))
    return (FALSE);
   break;

  case STM_CMD_CLOSE:
   if (!fil_close (f))
    return (FALSE);
   break;

  case STM_CMD_READ:
   if (!fil_read (f,p,n))
    return (FALSE);
   break;

  case STM_CMD_WRITE:
   if (!fil_write (f,p,n))
    return (FALSE);
   break;

  case STM_CMD_SETPOS:
   if (!fil_setpos (f,n))
    return (FALSE);
   break;

  case STM_CMD_GETPOS:
   if (!fil_getpos (f,p))
    return (FALSE);
   break;

  default:
   return (FALSE);
 }

 return (TRUE);
}

/******************************************************************************/
/* ctx: blk                                                                   */
/******************************************************************************/

static STM_CTL (stm_ctl_b)
{
 PSX_BLK * b = (PSX_BLK *) ctx;

 switch (cmd)
 {
  case STM_CMD_CREATE:
  {
   PSX_BLK ** b = p;

   if (!blk_create (b))
    return (FALSE);
   break;
  }

  case STM_CMD_DELETE:
  {
   PSX_BLK ** b = p;

   if (!blk_delete (b))
    return (FALSE);
   break;
  }

  case STM_CMD_OPEN:
   break;

  case STM_CMD_CLOSE:
   break;

  case STM_CMD_READ:
   if (!blk_read (b,p,n))
    return (FALSE);
   break;

  case STM_CMD_WRITE:
   if (!blk_write (b,p,n))
    return (FALSE);
   break;

  case STM_CMD_SETPOS:
   if (!blk_setpos (b,n))
    return (FALSE);
   break;

  case STM_CMD_GETPOS:
   if (!blk_getpos (b,p))
    return (FALSE);
   break;

  default:
   return (FALSE);
 }

 return (TRUE);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/



