/******************************************************************************/
/* psx-str.h                                      String Handling             */
/******************************************************************************/
/** @file psx-str.h String Handling - Header File
 * Definitions supporting the functionalities of the String Handling module.
 */
 
#ifndef _psx_str_
#define _psx_str_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#define S_A_CHARS {131,133,134,145,160}  // variants of accented 'a'
#define C_A_CHARS {143,146}              // variants of accented 'A'

#define S_C_CHARS {135}                  // variants of accented 'c'
#define C_C_CHARS {128}                  // variants of accented 'C'

#define S_E_CHARS {130,136,137,138}      // variants of accented 'e'
#define C_E_CHARS {144}                  // variants of accented 'E'

#define S_I_CHARS {139,140,141,161}      // variants of accented 'i'
#define C_I_CHARS {}

#define S_N_CHARS {164}                  // variants of accented 'n'
#define C_N_CHARS {165}                  // variants of accented 'N'

#define S_O_CHARS {147,149,162}          // variants of accented 'o'
#define C_O_CHARS {}

#define S_U_CHARS {150,151,163}          // variants of accented 'u'
#define C_U_CHARS {}


/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

LINKAGE	BOOL	str_toupper	(char * src);

LINKAGE	BOOL	str_isspace	(const unsigned char * src);
LINKAGE	BOOL	str_isnil	(const char * src);
LINKAGE	BOOL	str_contains	(char * src,char * c);

LINKAGE	BOOL	str_tok		(const char * src,int * idx,const char * del,char * tok);
LINKAGE	BOOL	str_tok_w	(char * src,int * idx,char * tok);

LINKAGE	BOOL	str_trim	(unsigned char * src);
LINKAGE	BOOL	str_pad		(char * src,int n);
LINKAGE	BOOL	str_debrace	(char * src,char * tgt,char bl,char br);

LINKAGE	BOOL	str_gen_c	(char * src,char c,int n);

LINKAGE	BOOL	str_rem_chr_end	(char * src,char c);

LINKAGE BOOL    str_fmt_num     (char * src,int len);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_str_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/








