/******************************************************************************/
/* psx-sup.c                                            Support               */
/******************************************************************************/
/** @file psx-sup.c Support - Source Code File
 * Functions for support of randomization
 */
 
#include "psx.h"

/******************************************************************************/
/* Private                                                                    */
/******************************************************************************/
/** get random number beween min and max
 * @param num pointer to number
 * @param min minimum value
 * @param max maximum value
 */

BOOL rnd_get_num (NUM * num,NUM min,NUM max)
{
 NUM t;

 t = rand () % (max - min + 1) + min;

 *num = t;

 return (TRUE);
}

/******************************************************************************/
/** get random string between A and Z
 * @param str string
 * @param len length of string
 */

BOOL rnd_get_str (PSX_STR str,NUM len)
{
 int i;

 for (i = 0;i < len;i++)
 {
  NUM k;

  if (!rnd_get_num (&k,'A','Z'))
   return (FALSE);

  str [i] = (char) k;
 }

 str [len] = 0;

 return (TRUE);
}

 
/******************************************************************************/
/******************************************************************************/
/******************************************************************************/



