/******************************************************************************/
/* psx-sys-dbg.inl                                  system interface debug    */
/******************************************************************************/
/** @file psx-sys-dbg.inl System Interface: Debug - Inline Source Code File
 * Definitions and functions for helping debug the system interface during the
 * development process.
 */

typedef struct _SYS_MCX      // match context
{
 int sem;                    // semaphore
} SYS_MCX;

static struct _SYS_DBG       // debug
{
 SYS_MCX * mcx;
 NUM       n;
 int       sem;
} sys_dbg =
{
 NULL,
 0,
 0
};

/******************************************************************************/
/*                                                                            */
/******************************************************************************/
/* announce debug failure                                                     */
static BOOL dbg_fail (char * msg)
{
 printf ("\n\n\n");
 printf ("SYSTEM DEBUG FAILURE");

 if (msg)
  printf (": %s",msg);

 printf ("\n\n\n");
 fflush (stdout);

 exit (-1);

 return (TRUE); // never reached
}

/******************************************************************************/
/*                                                                  dbg / mcx */
/******************************************************************************/

/******************************************************************************/
/* */
static BOOL dbg_mcx_get (SYS_MCX * mcx)
{
 if (mcx == NULL)
  return (FALSE);

 mcx -> sem = sys_dbg.sem;

 return (TRUE);
}

/******************************************************************************/

static BOOL dbg_mcx_push (SYS_MCX * mcx)
{
 SYS_MCX * t;

 if (mcx == NULL)
  return (FALSE);

 if ((t = (SYS_MCX *) realloc (sys_dbg.mcx,(sys_dbg.n + 1) * sizeof (SYS_MCX))) == NULL)
  return (FALSE);

 sys_dbg.mcx = t;
 sys_dbg.mcx [sys_dbg.n] = *mcx;
 sys_dbg.n ++;

 return (TRUE);
}

/******************************************************************************/

static BOOL dbg_mcx_pop (SYS_MCX * mcx)
{
 if (mcx == NULL)
  return (FALSE);

 if (sys_dbg.n == 0)
  return (FALSE);

 *mcx = sys_dbg.mcx [sys_dbg.n - 1];

 if (sys_dbg.n > 1)
 {
  SYS_MCX * t;

  if ((t = (SYS_MCX *) realloc (sys_dbg.mcx,(sys_dbg.n - 1) * sizeof (SYS_MCX))) == NULL)
   return (FALSE);

  sys_dbg.mcx = t;
  sys_dbg.n --;
 }
 else
 {
  free (sys_dbg.mcx);
  sys_dbg.mcx = NULL;
  sys_dbg.n = 0;
 }

 return (TRUE);
}

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

static BOOL dbg_mem_allocate (PTR p)
{
 if (!sys.dbg) return (TRUE);

 sys_dbg.sem ++;

 // printf ("dbg: allocate  : %d (%p)\n",sys_dbg.sem,p);

 return (TRUE);
}

/******************************************************************************/

static BOOL dbg_mem_reallocate (PTR p0,PTR p1)
{
 if (!sys.dbg) return (TRUE);

 if (p0 == NULL && p1 != NULL)
  sys_dbg.sem ++;
 else
  if (p0 != NULL && p1 == NULL)
   sys_dbg.sem --;

 //printf ("dbg: reallocate: %d (%p -> %p)\n",sys_dbg.sem,p0,p1);

 return (TRUE);
}

/******************************************************************************/

static BOOL dbg_mem_free (PTR p)
{
 if (!sys.dbg) return (TRUE);

 sys_dbg.sem --;

 //printf ("dbg: free      : %d (%p)\n",sys_dbg.sem,p);

 return (TRUE);
}

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

static BOOL dbg_init ()
{
 if (!sys.dbg) return (TRUE);
 return (TRUE);
}

/******************************************************************************/

static BOOL dbg_exit ()
{
 if (!sys.dbg) return (TRUE);

 return (TRUE);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


