/******************************************************************************/
/* psx-sys.h                                                 System Interface */
/******************************************************************************/
/** @file psx-sys.h System Interface - Header File
 * Definitions supporting the functionality of the System Interface by defining
 * basic datatypes like BOOL and its values TRUE and FALSE.
 */


#ifndef _psx_sys_
#define _psx_sys_


/******************************************************************************/
/* Interface                                                                  */
/******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <time.h>
#include <limits.h>
#include <assert.h>
#include <errno.h>

#include <signal.h>

#ifdef HAVE_NETDB_H
#  include <netdb.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>

#ifdef HAVE_SYS_WAIT_H
#  include <sys/wait.h>
#endif

/******************************************************************************/
/* Linkage                                                                    */
/******************************************************************************/

#ifdef __cplusplus
#define LINKAGE extern "C"
#else
#define LINKAGE
#endif

/******************************************************************************/
/* Definition                                                                 */
/******************************************************************************/

/**************************************/
/* Type                         Basic */
/**************************************/

typedef	int			INT;
typedef	unsigned long int	NUM;
typedef	unsigned long int	TYPE;
typedef	char			CHR;
typedef	unsigned char		BYTE;
typedef	unsigned short int	WORD;
typedef	unsigned long int	DWORD;


#ifndef BOOL
typedef	int			BOOL;
#endif

#ifndef TRUE
#define	TRUE			1
#endif

#ifndef FALSE
#define	FALSE			0
#endif


typedef	unsigned long int	IDX;
#define	IDX_NIL			0xFFFFFFFF

typedef	void * PTR;
#define	PTR_OFS(p,o) (((char *) p) + (o))

/**************************************/
/* Type                      Extended */
/**************************************/

#define SYS_STR_MAX 0x0400                     // maximum system stringsize = 1024 char
typedef char SYS_STR [SYS_STR_MAX];            // sytem string definition

#define PSX_STR_MAX 0x0400                     // maximum psx stringsize = 1024 char
typedef char PSX_STR [PSX_STR_MAX];            // psx string definition

#define PSX_LSTR_MAX 0x5000                 // maximum psx long stringsize =  4096 char //AB:gendert auf 20480
typedef char PSX_LSTR[PSX_LSTR_MAX];         // psx long string definition

typedef PSX_STR PSS_STR;                       // compatibility

#define PSX_BUF_MAX 0x400                      // maximum buffer size = 1024
typedef BYTE PSX_BUF [PSX_BUF_MAX];            // psx byte buffer definition

typedef NUM STS;

/******************************************************************************/
/* Macro                                                                      */
/******************************************************************************/

                                            // allocate memory for type
#define SYS_ALLOCATE(type) ((type *) malloc (sizeof (type)))
#define SYS_FREE(ptr) free (ptr)            // free pointer memory

// macro defines type structure with name id and make instance
#define SYS_STRUCTURE(id) typedef struct _##id id; struct _##id


#define ASSERT(cnd) assert(cnd)             // define assert macro to assert
                                            // that cnd is not null

#define	TRACE(s)	printf (">>> %s\n",s);    // output s

/**************************************/
/* Bit Manipulation                   */
/**************************************/

// bitwise logical comparison, result is in a
#define TEST(a,b)  ((a) & (b))              // true or false
#define AND(a,b)   ((a) &= (b))
#define OR(a,b)    ((a) |= (b))
#define XOR(a,b)   ((a) ^= (b))
#define NOT(a)	 (!(a))

#define BIT(n) (1 << (n))                   // bitshift n to left


#ifndef LOBYTE
#define LOBYTE(w)	((w) & 0x00FF)            // get lower byte
#define HIBYTE(w)	(((w) & 0xFF00) >> 8)     // get upper byte
#endif
#define MKWORD(bl,bh)	(((bh) << 8) | (bl))  // Bitshift(bh) 8 bits to the left
                                            // append bl to bh by logical OR
/******************************************************************************/

typedef unsigned char *POINTER;

//typedef unsigned short int UINT2;

//typedef unsigned long int UINT4;

#if PROTOTYPES
#define PROTO_LIST(list) list
#else
#define PROTO_LIST(list) ()
#endif


/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

/** system argument structure
 */
 
SYS_STRUCTURE (SYS_ARG)
{
 int     c;            /*+< number of arguments in v  */
 char ** v;            /**< arguments from stdin      */
 char *  s;            /**< storage, if present, free */
};

typedef SYS_ARG ARG;

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#define malloc  sys_malloc
#define realloc sys_realloc
#define free    sys_free

#ifdef strdup
#undef strdup
#endif

#define strdup sys_strdup

#ifndef PSX_SYS_WIN
#define SYS_DBG_MEM_BEGIN { sys_dbg_mem_begin (); }
#define SYS_DBG_MEM_END   { sys_dbg_mem_end (__FILE__,__LINE__); }
#else
#define SYS_DBG_MEM_BEGIN
#define SYS_DBG_MEM_END
#endif  // PSX_SYS_WIN

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/



/**************************************/
/* initialization                     */
/**************************************/

LINKAGE	BOOL	sys_init	(int ac,char ** av);
LINKAGE	BOOL	sys_exit	(void);

/**************************************/
/*                                    */
/**************************************/

LINKAGE	BOOL	sys_arg_get	(SYS_ARG * arg);
LINKAGE	BOOL	sys_apt_get	(char * pth);

/**************************************/
/*                                    */
/**************************************/

LINKAGE	BOOL	sys_put_l	(const char * fmt,va_list l);
LINKAGE	BOOL	sys_put		(const char * fmt,...);

LINKAGE	BOOL	sys_msg_l	(const char * fmt,va_list l);
LINKAGE	BOOL	sys_msg		(const char * fmt,...);

LINKAGE	BOOL	sys_log_lf	(FILE * f,const char * fmt,va_list l);
LINKAGE	BOOL	sys_log_l	(const char * fmt,va_list l);
LINKAGE	BOOL	sys_log		(const char * fmt,...);

LINKAGE	BOOL	sys_env_get	(const char * atr,char * val);

LINKAGE	BOOL	sys_fail	(const char * fmt,...);

/**************************************/
/* Memory Management                  */
/**************************************/

LINKAGE	BOOL	sys_allocate	(PTR p,NUM n);
LINKAGE	BOOL	sys_reallocate	(PTR p,NUM n);
LINKAGE	BOOL	sys_deallocate	(PTR p);

LINKAGE	PTR	sys_malloc	(NUM n);
LINKAGE	PTR	sys_realloc	(PTR p,NUM n);
LINKAGE	void	sys_free	(PTR p);
LINKAGE	char *	sys_strdup	(const char * src);

/**************************************/
/* Debug Management                   */
/**************************************/

LINKAGE	BOOL	sys_dbg_mem_begin	();
LINKAGE	BOOL	sys_dbg_mem_end		(const char * file,int line);

LINKAGE	BOOL	sys_dbg_mem_get_sem	(int * sem);

/**************************************/
/*                                    */
/**************************************/

LINKAGE	BOOL	sys_execute	(const char * c,char * i,char ** o,char ** e,int * r);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/
/**************************************/
/* Input Character Set                */
/**************************************/

typedef BYTE ICS;

#define ICS_ZERO  0x00
#define ICS_ISO   0x01
#define ICS_DIN   0x02

#endif // _psx_sys_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


