/******************************************************************************/
/* psx-tmi.c                                        Time Management Interface */
/******************************************************************************/
/** @file psx-tmi.c Time Management Interface - Source Code File
 * Functions providing the retrieval of start and stop time of psx and also
 * the duration of processing.
 */
 
#include "psx.h"

/******************************************************************************/
/* Private                                                                    */
/******************************************************************************/

/******************************************************************************/
/* Public                                                                     */
/******************************************************************************/
/** get starttime
 * @param tmg time management structure after invocation
 */

BOOL tmi_tmg_start (TMI_TMG * tmg)
{
 if (tmg == NULL)
  return (FALSE);

 memset (tmg,0,sizeof (*tmg));

 tmg -> cl0 = clock ();

 return (TRUE);
}

/******************************************************************************/
/** get stop time
 * @param tmg time management structure after invocation
 */
 
BOOL tmi_tmg_stop (TMI_TMG * tmg)
{
 if (tmg == NULL)
  return (FALSE);

 tmg -> cl1 = clock ();

 return (TRUE);
}

/******************************************************************************/
/** get time formatted time
 * @param tmg time management structure (input)
 * @param str formatted time (return)
 */
 
BOOL tmi_tmg_fmt (TMI_TMG * tmg,PSX_STR str)
{
 long l;
 int i,j;

 if (tmg == NULL || str == NULL)
  return (FALSE);

 //    end = clock() - start;

 l = (tmg -> cl1 - tmg -> cl0) / (CLOCKS_PER_SEC / 1000) + 1;
 i = l / 1000;
 j = l % 1000;
 sprintf (str,"%d.%03d",i,j);

 return (TRUE);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


