/******************************************************************************/
/* psx-tmi.h                                                   Time Interface */
/******************************************************************************/
/** @file psx-tmi.h Time Interface - Header File
 * Definitions and prototypes supporting the Time Management Interface in its
 * usage.
 */
 
#ifndef _psx_tmi_
#define _psx_tmi_

/******************************************************************************/
/* Interface                                                                  */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/* Definition                                                                 */
/******************************************************************************/

typedef struct
{
 clock_t   cl0;                         /* timing: clock start                */
 clock_t   cl1;                         /* timing: clock stop                 */
 clock_t   clr;                         /* timing: clock run                  */
} TMI_TMG;

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

LINKAGE	BOOL	tmi_tmg_start		(TMI_TMG * tmg);
LINKAGE	BOOL	tmi_tmg_stop		(TMI_TMG * tmg);
LINKAGE	BOOL	tmi_tmg_fmt		(TMI_TMG * tmg,PSX_STR str);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_tmi_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/




