/******************************************************************************/
/* psx-tui-req.inl                                    Template User Interface */
/******************************************************************************/
/** @file psx-tui-req.inl Template User Interface: Request - Inline Source Code File
 * Functions for creation of HTML formatted request input table.
 */

/******************************************************************************/
/** create HTML formatted table row                                               
 * @param lf label of field                                                   
 * @param rt input field (HTML formatted)                             
 * @return HTML formatted row element containing the specified input field
 */
static HTX tpr_req_row (HTX lf,HTX rt)
{
 HTX x1,x2,x;

 if (lf == HTX_NIL || rt == HTX_NIL)
  return (HTX_NIL);

 x1 = hci_tag (lf,"font","face='%s' size='%d' color='#FFFFFF'",tpl_fnt_face,tpl_fnt_size);
 x2 = hci_tag (rt,"font","face='%s' size='%d' color='#FFFFFF'",tpl_fnt_face,tpl_fnt_size);

 x1 = hci_td (NULL,NULL,"right",NULL,NULL,CLR_NIL,x1);
 x2 = hci_td (NULL,NULL,NULL,NULL,NULL,CLR_NIL,x2);

 x = hci_tr (hci_gen ("xx",x1,x2));

 return (x);
}

/******************************************************************************/
/** create HTML input element according to datatype of specified item          
 * (text field, option buttons, selection)                                    
 * @param itm: item (of format specification)                                 
 * @return HTML-formatted input element
 */
static HTX tpr_req_ctl (FSP_ITM * itm)
{
 PSX_STR s,l;
 HTX x;

 if (itm == NULL)
  return (HTX_NIL);

 sprintf (s,"fld_%s",itm -> sym);  // s: name of field, prefix "fld_"
 sprintf (l,"%d",itm -> len);      // l: length of field

 switch (itm -> dtp)               // switch datatype
 {
  case DTP_SEX:
  {
	  x = hci_select (s,"1",":;M:male;F:female;N:unknown");
   break;
  }

  case DTP_HIO:
  {
   PSX_STR t,o;

   if (!hfi_hio_lst_hml (t))
    return (FALSE);

   strcpy (o,":;");
   strcat (o,t);

   x = hci_select (s,"1",o);
   break;
  }

  default:
    x = hci_input (s,"text",NULL,l,MAX_INP_SIZE);    // create input field "s" of length l
    break;
 }

 return (x);
}

/******************************************************************************/
/** create HTML formatted request input table
 * @param ctx template user inferface context                                 
 * @return HTML element containing table
 */
 
static HTX prc_req (TUI_CTX * ctx)
{
 HTX x,t,u,v;
 IDX i;
 PSX_STR s;
 char * log;

 if (ctx == NULL)
  return (HTX_NIL);

 if (ctx -> sch == NULL)
  return (HTX_NIL);

 assert (ctx -> sch != NULL);

 t = hci_gen (NULL);
 // for each element of format specification:
 for (i = 0;i < ctx -> sch -> fsp -> n;i++)
 {
  HTX x1,x2,r;
  //PSX_STR s,l;

  if (ctx -> sch -> fsp -> itm [i].sym == NULL)
   return (HTX_NIL);;

  //sprintf (s,"fld_%s",ctx -> sch -> fsp -> itm [i].sym);
  //sprintf (l,"%d",ctx -> sch -> fsp -> itm [i].len);

  x1 = hci_txt (ctx -> sch -> fsp -> itm [i].lbl);      // HTML text (label)
  //x2 = hci_input (s,"text",NULL,l,MAX_INP_SIZE); // "10");
  x2 = tpr_req_ctl (&ctx -> sch -> fsp -> itm [i]);     // create HTML input field
  r = tpr_req_row (x1,x2);                              // create HTML table row

  if (!hci_add (t,r))
   return (HTX_NIL);
 } // end for

 {
  HTX x1,x2,xa,xb,xc,xd,r;

  x1 = hci_txt ("Sureness");  
  xa = hci_input ("fld_sur","radio","1",NULL,NULL); // create input field, type radio button
  xb = hci_txt ("sure");                       // create text field, text = "sure"
  xc = hci_input ("fld_sur","radio","0",NULL,NULL);
  xd = hci_txt ("unsure");

  x2 = hci_gen ("xxxx",xa,xb,xc,xd);

  r = tpr_req_row (x1,x2);      // create HTML table row

  if (!hci_add (t,r))
   return (HTX_NIL);
 }

 t = hci_table (0,NULL,NULL,CLR_CLI,NULL,NULL,t); // create table

 //strcpy (s,"ctx=req&sts=1");

 //if (psx.dbg)
 // strcat (s,"&dbg=1");

 x = t; //= tpr_doc ("PSX Request",s,"cmd_send:Send",t);


 return (x);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


