/******************************************************************************/
/* psx-tui-ret.inl                                    Template User Interface */
/******************************************************************************/
/** @file psx-tui-ret.inl Template User Interface: Return - Inline Source Code File
 * Functions for creation of HTML formatted return table containing the result
 * of the request.
 */

/******************************************************************************/
/** invoke creation of a table cell
 * @param aln string pointer to alignment specification
 * @param txt string pointer to table contents
 * @return x html formatted table
 */
 
static HTX tpr_ret_cll (const char * aln,const char * txt)
{
 HTX x;

 x = hci_td (NULL,NULL,aln,NULL,NULL,CLR_NIL,hci_txt (txt)); /* invoke hci_txt()*/

 return (x);
}

/******************************************************************************/
/** invoke creation of a table row consisting of 2 cells
 * @param lbl string pointer to label
 * @param string pointer to table contents
 * @param html formatted table cell
 */
   
static HTX tpr_ret_row_2 (const char * lbl,const char * txt)
{
 HTX x,x1,x2;
 PSX_STR t;

 sprintf (t,"%s: ",lbl);

 x1 = tpr_ret_cll ("right",t);
 x2 = tpr_ret_cll ("left" ,txt);
 x = hci_tr (hci_gen ("xx",x1,x2));

 return (x);
}

/******************************************************************************/
/** invoke creation of a table row consisting of 4 cells
 *     +------------------------------+----------+------------------+
 *     | label 1   | text 1           |  label 2 | text 2           |
 *     +-----------+------------------+-----------------------------+
 *
 * @param l1 string pointer to label 1
 * @param t1 string pointer to text 1 
 * @param l2 string pointer to label 2
 * @param t2 string pointer to text 2
 * @return x html formatted table row
 */
 
static HTX tpr_ret_row_4 (const char * l1,const char * t1,const char * l2,const char * t2)
{
 HTX x,x1,x2,x3,x4;
 PSX_STR p1,p2;

 if (!str_isnil (l1))
  sprintf (p1,"%s: ",l1);
 else
  strcpy (p1,"");

 if (!str_isnil (l2))
  sprintf (p2,"%s: ",l2);
 else
  strcpy (p2,"");

 x1 = tpr_ret_cll ("right",p1);
 x2 = tpr_ret_cll ("left" ,t1);
 x3 = tpr_ret_cll ("right",p2);
 x4 = tpr_ret_cll ("left" ,t2); 
 x = hci_tr (hci_gen ("xxxx",x1,x2,x3,x4));    // create row

 return (x);
}

/******************************************************************************/
/** invoke creation of a table showing account information
 * @return x html formatted table
 */
 
static HTX tpr_ret_acc ()
{
 HTX t,x,d1,d2,r1,r2;

 x = hci_gen (NULL);

 t = tpr_ret_row_4 ("User","$USR","Notification","$NOT"); 
 hci_add (x,t);
 t = tpr_ret_row_4 ("Host","$HST:$PRT [$ADR]","","");
 hci_add (x,t);
 t = tpr_ret_row_4 ("Time","$TSP","","");
 hci_add (x,t); 

 x = hci_table (0,"100%","1",CLR_BOX,NULL,NULL,x);

 return (x);
}

/******************************************************************************/
/** create HTML formatted table containing result (PID, message and other information)
 * @return HTML element containing table
 */
 
static HTX prc_ret ()
{
 HTX x,t,c,f,x1,x2,r1,r2,r3,r4;

 //t = hci_input ("TXT_PID","text","$PID","10",MAX_INP_SIZE);
 t = hci_txt ("$PID");
 t = hci_font ("courier",3,CLR_TXT,t);
 t = hci_gen ("txt","<br>",t,"<br>&nbsp;");
 t = hci_td (NULL,NULL,"center",NULL,NULL,CLR_NIL,t);

// t = hci_td (NULL,NULL,"center",NULL,NULL,CLR_NIL,hci_txt ("<br><br><br>$PID"));
 r2 = hci_tr (t);

 t = hci_td (NULL,NULL,"center",NULL,NULL,CLR_NIL,hci_txt ("<br>$MSG<br>&nbsp;<hr>"));
 r3 = hci_tr (t);

 t = tpr_ret_acc ();
 //t = hci_txt ("REMAINDER");
 t = hci_td (NULL,NULL,"center","bottom",NULL,CLR_NIL,t);
 r4 = hci_tr (t);

 x = hci_gen ("xxx",r2,r3,r4);
 x = hci_table (0,"100%","100%",CLR_CLI,NULL,NULL,x);

 //c = hci_txt ("$CTN");
 //c = hci_textarea ("ctn","80","15","virtual",TRUE,c);
 //hci_add (x,c);

 return (x);
}


/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


