/******************************************************************************/
/* psx-tui-sys.inl                                    Template User Interface */
/******************************************************************************/
/** @file psx-tui-sys.inl Template User Interface: System - Inline Source Code File
 * Functions providing the generation of a hypertext system page.
 */


/******************************************************************************/
/** create html code: create row
 * @param lf html text, label field
 * @param rt html text, right field
 * @return x html text label
 */
 
static HTX tpr_sys_row1 (HTX lf,HTX rt)
{
 HTX x1,x2,x;

 if (lf == HTX_NIL || rt == HTX_NIL)
  return (HTX_NIL);

 x1 = hci_tag (lf,"font","face='%s' size='%d' color='#FFFFFF'",tpl_fnt_face,tpl_fnt_size);
 x2 = hci_tag (rt,"font","face='%s' size='%d' color='#FFFFFF'",tpl_fnt_face,tpl_fnt_size);

 x1 = hci_td (NULL,NULL,"right",NULL,NULL,CLR_NIL,x1);
 x2 = hci_td (NULL,NULL,NULL,NULL,NULL,CLR_NIL,x2);

 x = hci_tr (hci_gen ("xx",x1,x2));

 return (x);
}

/******************************************************************************/
/** create html text: create table row with label and text
 * @param lbl string pointer to label name string
 * @param txt string pointer to text
 * @return x html formatted table row
 */
 
static HTX tpr_sys_row (const char * lbl,const char * txt)
{
 HTX x,x1,x2;
 PSX_STR t;

 sprintf (t,"%s: ",lbl);

 x1 = hci_td ("50%",NULL,"right",NULL,NULL,CLR_NIL,
 	hci_font (NULL,3,0x000000,hci_txt (t)));
 x2 = hci_td ("50%",NULL,"left",NULL,NULL,CLR_NIL,
 	hci_font (NULL,3,0xFFFFFF,hci_txt (txt)));

 x = hci_tr (hci_gen ("xx",x1,x2));

 return (x);
}

/******************************************************************************/
/** invoke html text creation: add a row to html text
 * @param par html text, label of table row
 * @param lf html text, left column specification
 * @param rt html text, right column specification
 * @return par html formatted table
 */
 
static HTX tpr_sys_row_add (HTX par,HTX lf,HTX rt)
{
 HTX r;

 r = tpr_sys_row1 (lf,rt);         // generate row

 if (!hci_add (par,r))             // add row
  return (HTX_NIL);

 return (par);
}

/******************************************************************************/
/** invoke generation of table rows, one for each label
 * @param ctx pointer to TUI context structure
 */
 
static HTX tpr_sys_doc (TUI_CTX * ctx)
{
 HTX x,t,r,x1,x2;

 x = hci_gen (NULL);

 t = tpr_sys_row ("PIX","$PIX");
 hci_add (x,t);

 t = tpr_sys_row ("Records","$REC");
 hci_add (x,t);

 t = tpr_sys_row ("Requests","$REQ");
 hci_add (x,t);

 t = tpr_sys_row ("Retrievals","$REQ_POS");
 hci_add (x,t);
 
 t = tpr_sys_row ("Last Request","$REQ_TSP");
 hci_add (x,t);

 x = hci_table (0,"100%",NULL,CLR_CLI,NULL,NULL,x);

 return (x);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


