/******************************************************************************/
/* psx-tui.h                                          Template User Interface */
/******************************************************************************/
/** @file psx-tui.h Template User Interface - Header File
 * Definitions supporting the functionality of the Template User Interface like
 * the definition of the TUI Context structure and the template identities
 */
 
#ifndef _psx_tui_
#define _psx_tui_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/* Type                                                                       */
/******************************************************************************/

/**************************************/
/* Template Identity                  */
/**************************************/

/** template identity                 */
typedef BYTE TPL;

#define TPL_ZERO	0x00            /**< zero                               */
#define TPL_PTL		0x01            /**< portal                             */
#define TPL_SYS		0x02            /**< system                             */
#define TPL_REQ		0x03            /**< request                            */
#define TPL_RET		0x04            /**< return                             */
#define TPL_MSG		0x05            /**< message                            */
#define TPL_CFM		0x06            /**< confirmation                       */
#define TPL_NIL		0xFF            /**< nil                                */

/**************************************/
/* TUI Context                        */
/**************************************/

typedef struct _TUI_CTX
{
 TPL       tpl;                        /**< template                      */
 PSX_SCH * sch;                        /**< schema                        */
 PSX_DIC * dic;                        /**< dictionary                    */
 BOOL      dbg;                        /**< debug mode                    */
 PSX_STR   tgt;                        /**< target address                */
} TUI_CTX;

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

LINKAGE	BOOL	tui_doc_put	(TUI_CTX * ctx,PSX_DOC * doc);
LINKAGE	BOOL	tui_tpl_put	(TUI_CTX * ctx);

LINKAGE	BOOL	tui_put		(TUI_CTX * ctx);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_tui_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

