/******************************************************************************/
/* psx-tui.inl                                       Template User Interface  */
/******************************************************************************/
/** @file psx-tui.inl Template User Interface - Inline Source Code File
 * Definitions and functions supporting the functionality of the Template User
 * Interface like the invication of hypertext generation for each template page.
 */



/******************************************************************************/
/* Private                                            Template User Interface */
/******************************************************************************/

static char tpl_fnt_face[]	= "Courier"; //Helvetica,Arial";
static int	tpl_fnt_size	= 2;

//#define CLR_FRM	0x5050AA	/**< frame color      */  // dark purple
//#define CLR_BKG	0x000000  /**< background color */  // black
//#define CLR_BOX 	0xFFFF00  /**< box color        */  // purple
//#define CLR_BAR	0xB0B0FF  /**< bar color        */  // lighter purple
//#define CLR_CLI	0x8080FF  /**< input form color */

#define CLR_FRM	0x000066  /**< frame color      */
#define	CLR_BKG	0x99CCCF  /**< background color */  
#define CLR_BOX 0x699C9F  /**< box color        */ 
#define CLR_BAR	0xB9ECEF  /**< bar color        */ 
#define CLR_CLI	0x699C9F  /**< input form color */
#define CLR_TXT 0xFFFFFF


/******************************************************************************/
/** set template user interface target                    
 * @param ctx
 * @param tgt contains target
 * @param def dafault ["ctx=req" | "ctx=req&sts=0" | "ctx=req&sts=1"]
 */
 
static BOOL tui_tgt (TUI_CTX * ctx,PSX_STR tgt,const PSX_STR def)
{
 if (ctx == NULL || tgt == NULL)
  return (FALSE);

 if (!str_isnil (ctx -> tgt))
  strcpy (tgt,ctx -> tgt);
 else
  if (def)
   strcpy (tgt,def);                 // set default
  else
   strcpy (tgt,"?");

 if (psx.dbg)
  strcat (tgt,"&dbg=1");

 return (TRUE); 
}

/******************************************************************************/
/** template procedure box, generate html table
 * @param src html source text
 */
 
static HTX tpr_box (HTX src)
{
 HTX x;

 x = hci_table (2,NULL,NULL,0xFF0000,NULL,NULL,hci_tr (hci_td (NULL,NULL,NULL,NULL,NULL,CLR_NIL,src)));

 return (x);
}

/******************************************************************************/
/** create submit button 
 * @param spc specification of button in format "name:value"
 */
 
static HTX tpr_cmd (const char * spc)
{
 HTX r,x;
 int i;
 PSX_STR s;

 if (spc == NULL)
  return (HTX_NIL);

 r = hci_gen (NULL);                             // generate html text

 i = 0;

 while (str_tok (spc,&i,";",s))
 {
  char n [1000],v [1000];
  int j = 0;
  HTX b;

  if (!str_tok (s,&j,":",n))
   continue;

  if (!str_tok (s,&j,":",v))
   continue;

  b = hci_input (n,"submit",v,NULL,NULL);        // generate html text
  hci_add (r,b);
 }

 return (r);
}

/******************************************************************************/
/** template procedure frame
 * @param src html source text
 * @param act string pointer to action string
 * @param cmd string pointer to command string
 */
    
static HTX tpr_frm (HTX src,char * act,char * cmd)
{
 HTX x,c,t,t1,t2;
 PSX_STR s;
 int i;

 i = 0;

 if (cmd)
  c = tpr_cmd (cmd);
 else
  c = HTX_NIL;

 t1 = hci_tr (hci_td (NULL,NULL,"center",NULL,NULL,CLR_NIL,src));
 t2 = hci_tr (hci_td (NULL,NULL,"center",NULL,NULL,CLR_NIL,c));
 t = hci_gen ("xx",t1,t2);
 t = hci_table (0,"100%","100%",0xFF00FF,NULL,NULL,t);

//t = src;
 sprintf (s,"psx.cgi?%s",act);
 t = hci_form (s,"post",t);
 x = tpr_box (t);
}

/******************************************************************************/
/* Included inline-files:                                                     */
/******************************************************************************/

#include "psx-tui-ptl.inl"
#include "psx-tui-sys.inl"
#include "psx-tui-req.inl"
#include "psx-tui-ret.inl"


/******************************************************************************/
/* template procedure debug
 */
 
static HTX tpr_dbg ()
{
 HTX t;
 char * log;

 if (psx_log_get (&log))
 {
  t = hci_txt (log);
  free (log);
 }
 else
  t = hci_txt ("no debug information");

 t = hci_textarea ("ctn","80","15","off",TRUE,t);
 //t = hci_td (NULL,NULL,"center",NULL,NULL,CLR_NIL,t);
 //t = hci_tr (t);
 //t = hci_table (1,"100%","100%",CLR_NIL,NULL,NULL,t);
 t = hci_form (NULL,NULL,t);
 
 return (t);
}

/******************************************************************************/
/** template procedure document, create HTML document
 * @param ctx strig pointer to template user interface context      
 * @param ttl string pointer to title string, title appears on top of page        
 * @param act string pointer to action string in form action                
 * @param cmd string pointer to name and value string of submit button      
 * @param src HTX pointer to HTML formatted part of HTML document 
 * @return HTML document
 */
 
static HTX tpr_doc (TUI_CTX * ctx,const char * ttl,const char * act,const char * cmd,HTX src)
{
 HTX t,x,xt,xm,xb,d;

 t = hci_txt (ttl);
 t = hci_tag (t,"b","");
 t = hci_tag (t,"font","face='Verdana' size='2' color='#000000'");
 t = hci_tag (t,"p","align='center'");
 xt = t;
 xm = src;
 t = tpr_cmd (cmd);
 xb = t;

 xt = hci_tag (xt,"td","height='48' bgcolor='#%06X'",CLR_BAR);
 xm = hci_tag (xm,"td","height='320' align='center' bgcolor='%06X'",CLR_CLI);
 xb = hci_tag (xb,"td","height='48' bgcolor='#%06X' align='center'",CLR_BAR);

 xt = hci_tag (xt,"tr","");
 xm = hci_tag (xm,"tr","");
 xb = hci_tag (xb,"tr","");

 t = hci_gen ("xxx",xt,xm,xb);
 t = hci_tag (t,"table","border='1' width='100%%' height='100%%' cellspacing='4'");

 t = hci_tag (t,"form","action='psx.cgi?%s' method='post'",act ? act : "");

 t = hci_tag (t,"td","height='100%%' align='center' valign='middle'");
 t = hci_tag (t,"tr","height='100%%'");
 t = hci_tag (t,"table","border='0' width='600' height='320' bgcolor='#%06X'",CLR_FRM); //XX
 t = hci_tag (t,"td","width='100%%' align='center' bgcolor='#%06X'",CLR_BKG);
 t = hci_tag (t,"tr","");
 t = hci_tag (t,"table","border='0' width='100%%' height='100%%' bgcolor='#%06X'",CLR_BKG);

 if (psx.dbg && ctx -> dbg)
 {
  d = tpr_dbg ();
  t = hci_gen ("xx",t,d);
 }

 t = hci_tag (t,"center","");
 t = hci_tag (t,"body","bgcolor='#%06X' text='#%06X'",CLR_BKG,CLR_TXT);

 x = hci_doc   // creates HTML document
 (
  ttl,
  t
 );

 return (x);
}


/******************************************************************************/
/* Private                                                                    */
/******************************************************************************/
/**template procedure portal: create portal page (BOOL tpr_ptl (TUI_CTX * ctx))
 * @param ctx pointer to TUI context structure
 */
 
static TPL_PROCEDURE (tpr_ptl)
{
 HTX x;
 PSX_STR s;

 //strcpy (s,"ctx=req");

 //if (psx.dbg)
 // strcat (s,"&dbg=1");

 tui_tgt (ctx,s,"ctx=req");
 x = prc_ptl (ctx);     // create unique (main) part of HTML page
 x = tpr_doc (ctx,"PID-Generator",s,"cmd:PID Request Form",x); // create whole HTML document

 return (TRUE);
}

/******************************************************************************/
/** template procedure system:create system page  (BOOL tpr_sys (TUI_CTX * ctx))
 * @param ctx pointer to TUI context
 */
 
static TPL_PROCEDURE (tpr_sys)
{
 HTX x;
 PSX_STR t;

 tui_tgt (ctx,t,"ctx=sys");
 
 x = tpr_sys_doc (ctx);    // create unique (main) part of HTML page
 x = tpr_doc (ctx,"PSX System Interface",t,"cmd:Update;cmd:Reset;cmd:History",x); // create whole HTML document

 return (TRUE);
}

/******************************************************************************/
/** template procedure request: create request page (BOOL tpr_req (TUI_CTX * ctx))
 * @param ctx pointer to TUI context
 */
 
static TPL_PROCEDURE (tpr_req)
{
 HTX x;
 PSX_STR t; 

 tui_tgt (ctx,t,"ctx=req&sts=1");  // t = target (action in HTML form)
 x = prc_req (ctx);  // HTML document containing request input form
 x = tpr_doc (ctx,"PID-Generator Request",t,"cmd:Send",x); // create whole HTML document

 return (TRUE);
}

/******************************************************************************/
/** template procedure return: create return page (BOOL tpr_ret (TUI_CTX * ctx))
 */
 
static TPL_PROCEDURE (tpr_ret)
{
 HTX x;
 PSX_STR s;

 strcpy (s,"ctx=req&sts=0");

 if (psx.dbg)
  strcat (s,"&dbg=1");

 x = prc_ret (ctx);
 x = tpr_doc (ctx,"PID-Generator Result",s,"cmd:Return",x); // create whole HTML document

 return (TRUE);
}

/******************************************************************************/
/** template procedure message: create return
 * @param ctx pointer to TUI context structure
 */
 
static TPL_PROCEDURE (tpr_msg)
{
 HTX t;
 PSX_STR s;

 tui_tgt (ctx,s,"ctx=req");
 
 t = hci_txt ("$TXT");
 t = tpr_doc (ctx,"PID-Generator Message",s,"cmd:Return",t); // create whole HTML document

 return (TRUE);
}

/******************************************************************************/
/** template procedure confirm: create confirm page (BOOL tpr_cfm (TUI_CTX * ctx))
 * @param ctx pointer to TUI context structure
 */
 
static TPL_PROCEDURE (tpr_cfm)
{
 HTX t;
 PSX_STR s;

 tui_tgt (ctx,s,"?");
 
 t = hci_txt ("$TXT");
 t = tpr_doc (ctx,"PSX",s,"cmd:OK;cmd:Cancel",t);   // create whole HTML document

 return (TRUE);
}

/******************************************************************************/
/** template procedure nil: create error page (BOOL tpr_nil (TUI_CTX * ctx))
 * @param ctx pointer to TUI context structure
 */
 
static TPL_PROCEDURE (tpr_nil)
{
 HTX x,t;

 t = hci_txt ("PSX Internal Error");
 t = hci_font ("Helvetica,Arial",8,0x00FF00,t);
 x = tpr_doc (ctx,"PSX","","",t);      // create whole HTML document

 return (TRUE);
}

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


