/******************************************************************************/
/* psx-txt.h                                         Text Operation Interface */
/******************************************************************************/
/** @file psx-txt.h Text Operation Interface - Header File
 * Definitions and prototypes supporting the functionality of the Text
 * Operation Interface.
 */


#ifndef _psx_txt_
#define _psx_txt_

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/*                                                                            */
/******************************************************************************/

#define TXT_DEC_ZERO 0x00
#define TXT_DEC_N    0x01
#define TXT_DEC_F    0x02

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

LINKAGE	BOOL	txt_gen_chr	(char * src,char c,int n);
LINKAGE	BOOL	txt_val_len	(PSX_STR txt,NUM n);
LINKAGE	BOOL	txt_isMultiPart	(char * src);
LINKAGE	BOOL	txt_trim_r	(char * src);
LINKAGE	BOOL	txt_cvt_uml	(char * src);
LINKAGE	BOOL	txt_cvt_del	(char * src);
LINKAGE	BOOL	txt_dec		(char * src,BYTE dec,char * s1,char * s2,char * s3);
LINKAGE	BOOL	txt_construct	(PSX_STR txt,const char * rgs,const char * def,PSX_DIC * dic);
LINKAGE	BOOL	txt_isNameDel	(char c);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_txt_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/






