/******************************************************************************/
/* psx-wui.h                                               Web User Interface */
/******************************************************************************/
/** @filw psx-wui.h Web User Interface - Header File
 * Definitions and Prototypes supporting the functionality of the Web User
 * Interface.
 */
 
#ifndef _psx_wui_
#define _psx_wui_

/******************************************************************************/
/* Includes                                                                   */
/******************************************************************************/

#include "psx.h"

/******************************************************************************/
/* Definition                                                                 */
/******************************************************************************/

/**************************************/
/* Context                            */
/**************************************/

//typedef BYTE WUI_CTX;

/** Web User Interface Context definitions                                   */
#define WUI_CTX_ZERO 0x00            /**< zero                               */
#define WUI_CTX_SYS  0x01            /**< system                             */
#define WUI_CTX_PTL  0x02            /**< portal                             */
#define WUI_CTX_REQ  0x04            /**< request                            */
#define WUI_CTX_ERR  0x05            /**< error                              */
#define WUI_CTX_NIL  0xFF            /**< nil                                */

/**************************************/
/* Command                            */
/**************************************/
/** Web User Interface Comman definitions                                    */
#define WUI_CMD_NIL	0x00            /**< nil                                 */
#define WUI_CMD_RETURN	0x01        /**< command return                      */
#define WUI_CMD_RESET	0x02          /**< command reset                       */
#define WUI_CMD_OK	0x03            /**< command ok                          */
#define WUI_CMD_CANCEL	0x04        /**< command cancel                      */
#define WUI_CMD_HISTORY	0x05        /**< command history                     */

/**************************************/
/* Context                            */
/**************************************/

/** web user interface, contains request, environment, and response information */
typedef struct _WUI
{
 /* request */
 
 BYTE      ctx;     //!< interaction context     
 BYTE      sts;     //!< interaction status (0= new request, 1= process record)
 BYTE      cmd;     //!< command

 PSX_DIC * env;     //!< environment
 PSX_SCH * sch;     //!< schema                             
 PSX_FMT * fmt;     //!< format
 BOOL      dbg;     //! enable debugging                   
 
 /* response */
  
 TPL       tpl;     //!< document template 
 PSX_DIC * dic;     //!< dictionary                         
 PSX_STR   tgt;     //!< target 
} WUI;

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

LINKAGE	BOOL	wui_init	(WUI * wui);
LINKAGE	BOOL	wui_exit	(WUI * wui);
LINKAGE	BOOL	wui_put		(WUI * wui);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_wui_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

