/******************************************************************************/
/* psx.h                                                      Pseudonymizator */
/******************************************************************************/
/** @file psx.h Pseudonymisator - Headerfile
 * [P] 2000-2003 M. Wagner                                                    
 *               Institute for Medical Biometry, Epidemiology and Informatics 
 *               University of Mainz                                          
 *                                                                            
 *  Contribution:                                                             
 *                                                                            
 *  V. Hamm                                                                   
 *  I. Schmidtmann: control number generation                                 
 *  K. Pommerening: pid construction                                          
 *  J. Beigel:      health fund interface, ODBC driver
 *
 * All headerfiles of the different modules are put together in this file
 * supporting the idea of making all public functions (those with prototypes
 * in their corresponding headerfile) can be accessed from anywhere in the
 * programme. This is essential for the modularisation of the procedures.
 */

#ifndef _psx_
#define _psx_

/******************************************************************************/
/* Configuration                                                              */
/******************************************************************************/

#define	PSX_DBS	1               /* database                           */
#define	PSX_DRS	1               /* directory service                  */

/******************************************************************************/
/* Interface                                                                  */
/******************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>           /* configuration                     */
#endif

#include "psx-win.h"            /* definitions for Windows            */
#include "psx-sys.h"            /* system interface                   */
#include "psx-ver.h"            /* version control                    */
#include "psx-tmi.h"            /* time interface                     */
#include "psx-fsi.h"            /* file system interface              */
#include "psx-blk.h"            /* block management interface         */
#include "psx-stm.h"            /* stream interface                   */
#include "psx-stk.h"            /* stack interface                    */
#include "psx-lst.h"            /* list interface, not used           */
#include "psx-fio.h"            /* file i/o interface                 */
#include "psx-nci.h"            /* network connectivity interface     */
#include "psx-sci.h"            /* standard commandline interface     */
#include "psx-bci.h"            /* binary conversion interface        */
#include "psx-drs.h"            /* directory service interface        */
#include "psx-cti.h"            /* AES encryption interface           */
//#include "psx-tsp.h"            /* transformation specification, empty*/
#include "psx-fsp.h"            /* format specification interface     */
#include "psx-rsp.h"            /* result specification interface     */
#include "psx-psp.h"            /* procedure specification interface  */
#include "psx-spi.h"            /* specification parser interface     */
#include "psx-dic.h"            /* dictionary management interface    */
#include "psx-msi.h"            /* mail system interface              */
#include "psx-rec.h"            /* record management interface        */
#include "psx-stl.h"            /* string list interface              */
#include "psx-dbi.h"            /* database interface                 */
#include "psx-cpi.h"            /* cipher interface                   */
#include "psx-sch.h"            /* schema interface                   */
#include "psx-cmi.h"            /* cipher management interface        */
#include "psx-pmi.h"            /* pid management interface           */
#include "psx-md5.h"            /* hashing interface                  */
#include "psx-aes.h"            /* AES encryption interface           */
#include "psx-rgs.h"            /* registry management interface      */
#include "psx-cci.h"            /* compiler construction interface    */
#include "psx-cgi.h"            /* common gateway interface           */
#include "psx-hfi.h"            /* health fund interface              */
#include "psx-sup.h"            /* support                            */
#include "psx-str.h"            /* string handling                    */
#include "psx-txt.h"            /* text operation interface           */
#include "psx-exp.h"            /* expression interface               */
#include "psx-cvt.h"            /* conversion interface               */
#include "psx-pho.h"            /* phonetics interface                */
#include "psx-req.h"            /* pseudonymization request interface */
#include "psx-doc.h"            /* document handling                  */
#include "psx-hci.h"            /* hypertext construction interface   */
#include "psx-cni.h"            /* control number interface           */
#include "psx-pgi.h"            /* PID generation interface           */
#include "psx-pdi.h"            /* pseudonym database interface       */
#include "psx-mti.h"            /* matching interface                 */
#include "psx-psi.h"            /* pseudonymization service interface */
#include "psx-tui.h"            /* template user interface            */
#include "psx-wui.h"            /* web user interface                 */
#include "psx-gui.h"            /* graphical user interface           */
#include "psx-cmd.h"            /* command processing interface       */
#include "psx-int.h"            /* command line interface             */
#include "psx-dst.h"            /* distribution interface             */
#include "psx-smi.h"            /* stochastical matching interface    */

/******************************************************************************/
/* Definition                                                                 */
/******************************************************************************/

/**************************************/
/* Configuration                      */
/**************************************/

#define PSX_CFG_ZERO ""
#define PSX_CFG_FSP  "fsp"
#define PSX_CFG_DBS  "dbs"
#define PSX_CFG_LGF  "log.file"
#define PSX_CFG_LGM  "log.mask"

// BG
#define PSX_CFG_SQL_NULL "sql.null"
#define PSX_CFG_SQL_BEGIN "sql.begin"
#define PSX_CFG_SQL_COMMIT "sql.commit"
#define PSX_CFG_SQL_SEM "sql.sem"
#define PSX_CFG_SQL_ABORT "sql.abort"
// END BG


#define PSX_CFG_HST "History"     // history: requests are stored in unencoded in req table
#define PSX_CFG_HIC "ValidateHIC" // has to be turned on to enable checks on health insurance codes

#define PSX_CFG_INS_PSX "ins.psx"
#define PSX_CFG_INS_CFG "ins.cfg"
#define PSX_CFG_INS_CGI "ins.cgi"

#define PSX_MOD_SYS "sys"
#define PSX_MOD_CMD "cmd"
#define PSX_MOD_CPI "cpi"
#define PSX_MOD_AES "aes"
#define PSX_MOD_IDEA "idea"
#define PSX_MOD_CNI "cni"
#define PSX_MOD_DBI "dbi"
#define	PSX_MOD_DBI_ODBC "dbi/odbc"
#define	PSX_MOD_DBI_PGS	"dbi/pgsql"
#define PSX_MOD_PDI "pdi"
#define PSX_MOD_PSI "psi"
#define PSX_MOD_MTI "mti"

#define PSX_MOD_DST "dst"
#define PSX_MOD_SMI "smi"
//#define PSX_MOD_INT "int"

#define LOG psx_log_m

#define PSX_DBG 0

/******************************************************************************/
/* Type                                                                       */
/******************************************************************************/

/** Configuration.
 * Data structure holding the configuration.
 */
SYS_STRUCTURE (PSX)
{
 /** Registry structure.
  * Holds configuration strings that are given in configuration file as
  * attribute-value pairs.
  */
 PSX_RGS * rgs;
 FILE    * log;   /**< Logfile pointer */

 /** Additional configuration */
 struct
 {
  BOOL	verbose; /**< True if verbose output is set. */
 } cfg;

 BOOL cgi;    /**< True if html code is requested */
 BOOL dbg;    /**< Debug mode TRUE/FALSE */
 IDX  logpos; /**< Position in logfile (Offset) */

 PSX_STR key; /**< Global AES key */
};

extern PSX psx;

/******************************************************************************/
/* Service                                                                    */
/******************************************************************************/

LINKAGE	BOOL	psx_cfg_get	(const char * key,char * val);

LINKAGE	BOOL	psx_print	(const char * fmt,...);

LINKAGE	BOOL	psx_put		(const char * fmt,...);
LINKAGE	BOOL	psx_put_v	(const char * fmt,...);

LINKAGE	BOOL	psx_log_l	(const char * fmt,va_list l);
LINKAGE	BOOL	psx_log_m	(const char * mod,const char * fmt,...);
LINKAGE	BOOL	psx_log		(const char * fmt,...);
LINKAGE	BOOL	psx_log_get	(char ** txt);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/

#endif // _psx_

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/


