package org.tmf.client;

import java.net.URL;
import org.apache.axis.utils.Options;
import org.tmf.www.services.SubjectIdentificationService;
import org.tmf.www.services.SubjectIdentificationServiceLocator;
import org.tmf.www.services.SubjectList;
import org.cdisc.www.ns.odm.v1_2.ClinicalData;
import org.cdisc.www.ns.odm.v1_2.holders.ClinicalDataHolder;
import org.tmf.www.services.types.RequestSubjectID;
import org.tmf.www.services.types.ResponseSubjectID;
import org.cdisc.www.ns.odm.v1_2.ItemData;

public class GetSubjectData {
    /**
     * @param serviceURL
     * @param args
     */
    public void run(URL serviceURL, String[] args) throws Exception {
        if (args == null || args.length != 1) {
            System.err.println("Expected non-option 1 argument (subjectID)");
            return;
        }

        String pseusdonymValue = args[0];

        SubjectIdentificationService service = new SubjectIdentificationServiceLocator();

        Options opts = new Options(null);
        opts.setDefaultURL(service.getSubjectListAddress());
        SubjectList subjectList = service.getSubjectList(serviceURL);

        RequestSubjectID requestSubjectID = new RequestSubjectID();
        requestSubjectID.setValue(pseusdonymValue);

        ClinicalDataHolder clinicalDataHolder   = new ClinicalDataHolder();
        clinicalDataHolder.value = new ClinicalData();
        clinicalDataHolder.value.setStudyOID("Study.XXX");
        clinicalDataHolder.value.setMetaDataVersionOID("MDV.YYY");

        ResponseSubjectID responseSubjectID = subjectList.getSubjectData(requestSubjectID, clinicalDataHolder);
	System.out.println("getSubjectData " + responseSubjectID.getValue());
        System.out.println(responseSubjectID.getResponseCode().getValue());
	System.out.println(responseSubjectID.getMessage()[0].get_value());
        ItemData[] items = clinicalDataHolder.value.getSubjectData()[0].getStudyEventData()[0].getFormData()[0].getItemGroupData()[0].getItemData();
        int itemCount = items.length;

        for (int i = 0; i<itemCount; i++) {
                String oid = items[i].getItemOID();
                String val = items[i].getValue();
                System.out.println(oid + ": " + val);
        }

   }
}
