package org.tmf.client;

import java.net.URL;
import org.apache.axis.utils.Options;
import org.tmf.www.services.SubjectIdentificationService;
import org.tmf.www.services.SubjectIdentificationServiceLocator;
import org.tmf.www.services.SubjectList;
import org.tmf.www.services.SubjectListImpl;
import org.cdisc.www.ns.odm.v1_2.ClinicalData;
import org.cdisc.www.ns.odm.v1_2.holders.ClinicalDataHolder;
import org.tmf.www.services.types.RequestSubjectID;
import org.tmf.www.services.types.SubjectDataRef;
import org.tmf.www.services.types.holders.ResponseSubjectIDHolder;

public class GetSubjectIDTester {
    

    public static void main(String [] args) {
     try {
	if (args == null || args.length != 2) {
            System.err.println("Expected non-option 1 argument (subjectKey, sureness)");
            return;
        }
        
        String subjectKey = args[0];

        SubjectListImpl subjectList = new SubjectListImpl();

        ClinicalData clinicalDataIn = new ClinicalData();
        SubjectListHelper.addSubjects(1, clinicalDataIn);
        clinicalDataIn.getSubjectData(0).setSubjectKey(subjectKey);

        RequestSubjectID requestSubjectID = null;

	requestSubjectID = new RequestSubjectID();

        requestSubjectID.setSureness(args[1]);
       	SubjectDataRef ref = new SubjectDataRef();
       	requestSubjectID.setSubjectDataRef(ref);
       	ref.setSubjectKey(subjectKey);

        ResponseSubjectIDHolder subjectIDResponse = new ResponseSubjectIDHolder();
        ClinicalDataHolder      clinicalDataOut   = new ClinicalDataHolder();

        subjectList.getSubjectID(requestSubjectID, clinicalDataIn, subjectIDResponse, clinicalDataOut);

        System.out.println("getSubjectID " + subjectKey + " = " + subjectIDResponse.value.getResponseCode().getValue());
	System.out.println(subjectIDResponse.value.getValue() + " " + subjectIDResponse.value.getMessage()[0].get_value());

     } catch (Exception e) {
	System.err.println(e.toString());
     }
   }
}



