package org.tmf.client;

import java.net.URL;

import org.apache.axis.utils.Options;
import org.tmf.www.services.SubjectIdentificationService;
import org.tmf.www.services.SubjectIdentificationServiceLocator;
import org.tmf.www.services.SubjectList;
import org.tmf.www.services.types.RequestSubjectID;
import org.tmf.www.services.types.ResponseSubjectID;

public class IsSubjectIDValid {
    /**
     * @param serviceURL
     * @param args
     */
    public void run(URL serviceURL, String[] args) throws Exception {
        
        if (args == null || args.length != 1) {
            System.err.println("Expected non-option 1 argument (subjectID)");
            return;
        }
        
        String pseusdonymValue = args[0];
        
        SubjectIdentificationService service = new SubjectIdentificationServiceLocator();
        
        Options opts = new Options(null);
        opts.setDefaultURL(service.getSubjectListAddress());
        
        SubjectList subjectList = service.getSubjectList(serviceURL);
        
        RequestSubjectID requestSubjectID = new RequestSubjectID();
        requestSubjectID.setValue(pseusdonymValue);
        
        ResponseSubjectID response = subjectList.isSubjectIDValid(requestSubjectID);
        
        System.out.println("isSubjectIDValid " + requestSubjectID.getValue() + " = " + response.getResponseCode().getValue());
   }
}
