/**
 */

package org.tmf.client;


import java.io.BufferedReader;
import java.io.InputStreamReader;

import org.cdisc.www.ns.odm.v1_2.ClinicalData;
import org.cdisc.www.ns.odm.v1_2.FormData;
import org.cdisc.www.ns.odm.v1_2.ItemData;
import org.cdisc.www.ns.odm.v1_2.ItemGroupData;
import org.cdisc.www.ns.odm.v1_2.StudyEventData;
import org.cdisc.www.ns.odm.v1_2.SubjectData;

public class SubjectListHelper {

    private SubjectListHelper() {
        // defeat instantiation
    }

    public static void addSubjects(int numSubjects, ClinicalData clinicalData) {

        clinicalData.setStudyOID("Study.XXX");
        clinicalData.setMetaDataVersionOID("MDV.YYY");

        SubjectData[] subjects = new SubjectData[numSubjects];
        for (int i = 0; i < subjects.length; i++) {
            subjects[i] = new SubjectData();
            subjects[i].setSubjectKey("AAA" + numSubjects);

            StudyEventData event = new StudyEventData();
            event.setStudyEventOID("E.01");
            subjects[i].setStudyEventData(new StudyEventData[] { event });

            FormData form = new FormData();
            form.setFormOID("F.01");
            event.setFormData(new FormData[] { form });

            ItemGroupData ig = new ItemGroupData();
            ig.setItemGroupOID("IG.01");
            form.setItemGroupData(new ItemGroupData[] { ig });

            ItemData[] items =  new ItemData[35];
            for (int j = 0; j < items.length; j++)
	    	items[j] = new ItemData();
	    items[0].setItemOID("Sicherheit");
	    items[0].setValue("0");
	    items[1].setItemOID("Meldedatum");
	    items[1].setValue("01-01-2005");
	    items[2].setItemOID("Meldeeinrichtung");
	    items[2].setValue("456");
	    items[3].setItemOID("Arzt-ID");
	    items[3].setValue("123");
            items[4].setItemOID("VersichertenNummer1");
	    items[4].setValue("Nummer1");
	    items[5].setItemOID("VersichertenNummer2");
	    items[5].setValue("Nummer2");
	    items[6].setItemOID("KrankenkassenNummer");
            items[6].setValue("KKNum");
	    //items[7].setItemOID("Patienten-ID");
            //items[7].setValue("");
	    items[7].setItemOID("Geburtsdatum");
	    items[7].setValue("1956-12-30");
	    items[8].setItemOID("Titel");
	    items[8].setValue("Prof. Dr.");
	    items[9].setItemOID("Vornamen");
	    items[9].setValue("Hans-Peter");
	    items[10].setItemOID("Namenszusatz");
	    items[10].setValue("von");
	    items[11].setItemOID("Familienname");
	    items[11].setValue("Mller-Schmidt");
	    items[12].setItemOID("Geschlecht");
	    items[12].setValue("1");
	    items[13].setItemOID("Geburtsname");
	    items[13].setValue("Mller");
	    items[14].setItemOID("WohnortPLZ");
	    items[14].setValue("12345");
	    items[15].setItemOID("WohnortName");
	    items[15].setValue("Musterstadt");
	    items[16].setItemOID("Strasse_Hausnummer");
	    items[16].setValue("Musterstr. 56a");
	    items[17].setItemOID("TelefonNr");
	    items[17].setValue("keine Angaben");
	    items[18].setItemOID("FaxNr");
	    items[18].setValue("keine Angaben");
	    items[19].setItemOID("eMail");
	    items[19].setValue("hpmuster@muster.de");
	    items[20].setItemOID("GeburtsortPLZ");
	    items[20].setValue("");
	    items[21].setItemOID("GeburtsortName");
	    items[21].setValue("");
	    items[22].setItemOID("GeburtsWohnortPLZ");
	    items[22].setValue("");
	    items[23].setItemOID("GeburtsWohnortName");
	    items[23].setValue("");
	    items[24].setItemOID("KontaktTitel");
	    items[24].setValue("");
	    items[25].setItemOID("KontaktVornamen");
	    items[25].setValue("");
	    items[26].setItemOID("KontaktNamenszusatz");
	    items[26].setValue("");
	    items[27].setItemOID("KontaktFamilienname");
	    items[27].setValue("");
	    items[28].setItemOID("KontaktWohnortPLZ");
	    items[28].setValue("");
	    items[29].setItemOID("KontaktWohnortName");
	    items[29].setValue("");
	    items[30].setItemOID("KontaktStrass_Hausnummer");
	    items[30].setValue("");
	    items[31].setItemOID("KontaktTelefonNr");
	    items[31].setValue("");
	    items[32].setItemOID("KontaktFaxNr");
	    items[32].setValue("");
	    items[33].setItemOID("KontakteMail");
	    items[33].setValue("");
	    items[34].setItemOID("Studienteilnahme");
	    items[34].setValue("");

	   BufferedReader in = new BufferedReader (new InputStreamReader (System.in));
	   try {
	      for (int k = 0; k < items.length; k++) {
		System.out.print(items[k].getItemOID()+": ");
		items[k].setValue(in.readLine());
	     }
	   } catch (java.io.IOException e) {
	   	e.printStackTrace();
	   }

            ig.setItemData(items);
        }

        clinicalData.setSubjectData(subjects);
    }

}
