package org.tmf.client;

import java.io.PrintWriter;
import java.net.URL;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class TMFClient
{
   public static void main(String [] args) {
       try {
           CLInput input = new CLInput(args);

           URL serviceURL;
           
           serviceURL = new URL("http", input.server, input.port, "/axis/services/SubjectList");

               if (input.cmdIsValid) {
                   IsSubjectIDValid client = new IsSubjectIDValid();
                   client.run(serviceURL, input.args);
                   
               } else if (input.cmdGetSubjectID) {
                   GetSubjectID client = new GetSubjectID();
                   client.run(serviceURL, input.args);
                   
               } else if (input.cmdGetSubjectData) {
                   GetSubjectData client = new GetSubjectData();
		   System.out.println("run getSubjectData");
                   client.run(serviceURL, input.args);
               }

       } catch (Exception e) {
           System.err.println(e.toString());
       }
   }

    private static class CLInput {
        
        boolean ok = true;
        
        String server;
        int port;
        boolean cmdIsValid;
        boolean cmdGetSubjectID;
        boolean cmdGetSubjectData;
        boolean verbose;
        String[] args;
        
        private CLInput(String[] args) {
            // Create the options
            Options options = new Options();
            
            options.addOption("s", "server",   true,  "server");
            options.addOption("p", "port",     true,  "port");
            options.addOption("h", "help",     false, "display short help text");
            options.addOption("i", "isSubjectIDValid",  false, "subjectID");
            options.addOption("g", "getSubjectID",      false, "subjectKey submitted, sureness");
            options.addOption("d", "getSubjectData",    false, "subjectID");

            if (args == null || args.length == 0) {
                printHelpAndExit(options);
                ok = false;
            }
            
            try {
                // Read the commmand line
                CommandLineParser parser = new PosixParser();
                CommandLine       line = parser.parse(options, args);
                
                if (line.hasOption("h")) printHelpAndExit(options);
                
                server = "localhost";
                if (line.hasOption("s")) {
                    server = line.getOptionValue("s"); 
                }
                
                port = 8080;
                if (line.hasOption("p")) {
                    String tmp = line.getOptionValue("p");
                    try {
                        port = Integer.parseInt(tmp);
                    } catch (NumberFormatException nfe) {
                        System.out.println("port must be integer.");
                        System.exit(1);
                    }
                }

                cmdIsValid        = line.hasOption("i");
                cmdGetSubjectID   = line.hasOption("g");
                cmdGetSubjectData = line.hasOption("d");
                
                verbose   = line.hasOption("v");
                
                this.args = line.getArgs();
                
            } catch (ParseException ex) {
                System.out.println("Unexpected exception:" + ex.getMessage());
                ok = false;
            }           
        }
        
        private void printHelpAndExit(Options options) {
            
            PrintWriter pw = new PrintWriter(System.out);
            
            HelpFormatter formatter = new HelpFormatter();
            
            formatter.printHelp(pw, 60, "command [OPTIONS] command-args", "", options, 3, 4, "");
            
            pw.println();
            
            pw.close();
            
            System.exit(0);
        }   
        
        
    }
}
