/*** SubjectListImpl.java */

package org.tmf.www.services;

import java.net.URL;
import java.net.HttpURLConnection;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.IOException;
import java.io.FileInputStream;
import java.io.FileReader;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.sql.*;
import org.tmf.www.services.types.*;
import org.tmf.www.services.types.holders.*;
import org.tmf.www.services.SubjectList;
import org.cdisc.www.ns.odm.v1_2.SubjectData;
import org.cdisc.www.ns.odm.v1_2.FormData;
import org.cdisc.www.ns.odm.v1_2.StudyEventData;
import org.cdisc.www.ns.odm.v1_2.ItemGroupData;
import org.cdisc.www.ns.odm.v1_2.ItemData;
import org.cdisc.www.ns.odm.v1_2.ClinicalData;
import org.cdisc.www.ns.odm.v1_2.holders.ClinicalDataHolder;


public class SubjectListImpl implements SubjectList {

    public SubjectListImpl() {
        try {
            jbInit();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    // change this to actual path
    protected String configfile = "/etc/tmf/SubjectListService.cfg";
    protected Map oidRefMap = new HashMap(50); // maps input-itemOID to output-itemOID
    protected Map valueMap = new HashMap(50);  // maps output-itemOID to its value
    protected ConfigHolder config = new ConfigHolder();
    protected java.util.Vector fields = new java.util.Vector(20,10);

    /*** container for configuration */
    public class ConfigHolder {

        // default values
	String url= "";
	String mappingFile = "";
        String dbuser = "";
        String dburl = "";
        String dbpwd = "";
        String dbdriver = "org.postgresql.Driver";
        String fsex = "Geschlecht";
        String decomp = "no";

	public void ConfigHolder() {
	}

	private String getUrl() {
	 return this.url;
	}

	private void setUrl(String url) {
	 this.url = url;
	}

	private String getMappingFile() {
	  return this.mappingFile;
	}

	private void setMappingFile(String file) {
	 this.mappingFile = file;
	}

        private String getDbuser() {
         return this.dbuser;
        }

        private void setDbuser(String dbuser) {
         this.dbuser = dbuser;
        }

        private String getDburl() {
         return this.dburl;
        }

        private void setDburl(String dburl) {
         this.dburl = dburl;
        }

        private String getDbpwd() {
         return this.dbpwd;
        }

        private void setDbpwd(String pwd) {
         this.dbpwd = pwd;
        }

        private String getDbdriver() {
         return this.dbdriver;
        }

        private void setDbdriver(String driver) {
         this.dbdriver = driver;
        }

        private String getFsex() {
         return this.fsex;
        }

       private void setFsex(String field) {
         this.fsex = field;
       }

       private String getDecompBirthdate() {
         return this.decomp;
        }

       private void setDecompBirthdate(String decomp) {
         this.decomp = decomp;
       }

    }

    /*** container for psx query result */
    public class PsxDataHolder {
      String code;
      String message;
      String pid;

      public void PsxDataHolder() {
	}

	private String getCode() {
	 return this.code;
	}

	private void setCode(String code) {
	 this.code = code;
	}

	private String getMessage() {
	  return this.message;
	}

	private void setMessage(String msg) {
	 this.message = msg;
	}

	private String getPid() {
	  return this.pid;
	}

	private void setPid(String pid) {
	 this.pid = pid;
	}
    }
    /*********************************************************************************************************/

    public void getSubjectID(RequestSubjectID requestSubjectID, ClinicalData clinicalDataIn, ResponseSubjectIDHolder responseSubjectIDHolder, ClinicalDataHolder clinicalDataOut) throws java.rmi.RemoteException  {

	// get url and path to study definition (mapping of input OID to field names of PID-Generator)
	getConfig(configfile, config);

	// make oidRefMap which maps input OIDs to field names of PID-Generator
	makeOidRefMap(config.getMappingFile());

	// initiate valueMap (necessary in case of missing input items)
	Iterator oidIterator = oidRefMap.keySet().iterator();

	while (oidIterator.hasNext()) {
	   String key = (String)oidRefMap.get( (String) oidIterator.next());
	   valueMap.put(key, "");
	}

	// get items from input and store in valueMap
	ItemData[] items = clinicalDataIn.getSubjectData()[0].getStudyEventData()[0].getFormData()[0].getItemGroupData()[0].getItemData();

	for (int i = 0; i < items.length; i++) {
            try {
                String upperOID = (items[i].getItemOID()).toUpperCase();
                String oidRef = (String) oidRefMap.get(upperOID);
                if (oidRef != null)
                    valueMap.put(oidRef, items[i].getValue());
            } catch (Exception ex) {
                ex.printStackTrace();
            }
	}

	// get sureness from requestSubjectID
	String sur = "-"; // default
	if (requestSubjectID.getSureness() != null)
	   sur = requestSubjectID.getSureness();

	// encode sureness
	encodeSureness(sur);

	// encode sex
	encodeSex();

	// decompose birthdate
        if (config.getDecompBirthdate().equals("yes"))
            decomposeBirthdate();


	PsxDataHolder psx = new PsxDataHolder();
	psx.setMessage("");
	psx.setPid("");
	psx.setCode("");

	// call psx via cgi
	callPSX (config.getUrl(), psx);

	// set output IDATs = input IDATs;
	clinicalDataOut.value = clinicalDataIn;
	ResponseSubjectID responseSubjectID = new ResponseSubjectID();
        responseSubjectIDHolder.value = responseSubjectID;

	// output SubjectKey = input SubjectKey
	String subjectKey = clinicalDataIn.getSubjectData()[0].getSubjectKey();
	SubjectDataRef subjectDataRef = new SubjectDataRef();
	subjectDataRef.setSubjectKey(subjectKey);
 	responseSubjectID.setSubjectDataRef(new SubjectDataRef[] { subjectDataRef });

	if (psx.getPid() != null)
	   responseSubjectID.setValue(psx.getPid());

	if (psx.getCode().equals("Success")) {
		responseSubjectID.setResponseCode(ResponseSubjectIDResponseCode.Retrieved);
	} else {
		responseSubjectID.setResponseCode(ResponseSubjectIDResponseCode.NoMatch);
	}

	Message msg = new Message();
       	msg.set_value(psx.getMessage());
 	responseSubjectID.setMessage(new Message[] { msg });

   }
   /*********************************************************************************************************/

    public ResponseSubjectID getSubjectData(RequestSubjectID requestSubjectID, ClinicalDataHolder clinicalDataHolder) throws java.rmi.RemoteException {
        getConfig(configfile, config);

        /***  make fields array: mapping of item OIDs to field names of PID database */
        makeFieldArray(config.getMappingFile());

        /***  set default return values */
        ResponseSubjectID responseSubjectID = new ResponseSubjectID();
        String pid = requestSubjectID.getValue();
        responseSubjectID.setValue(pid);

        Message msg = new Message();
        msg.set_value("SubjectID does not exist.");
        responseSubjectID.setMessage(new Message[] { msg });
        responseSubjectID.setResponseCode(ResponseSubjectIDResponseCode.Invalid); //default: invalid

        ClinicalData clinicalData = clinicalDataHolder.value;

        /*** query subjectlist database */

        Class driverClass = loadDriver(config.getDbdriver());

        if (driverClass == null) {
            msg.set_value("Sorry. An error occurred");
            return responseSubjectID;
        }
        Connection con = connectURL(config.getDburl(), config.getDbuser(),config.getDbpwd());

        int rowCount = 0;
        ItemData[] itemsOut = new ItemData[fields.size()];

        if (con != null ) {
           String query =  "SELECT * FROM rec WHERE pid = '" + pid + "' and sub IS NULL";
           ResultSet result = execQuery(con, query);

           if (result != null)
             rowCount = matchResults ( result, itemsOut ); // get values from result and store in itemsOut

       } else {
           msg.set_value("Sorry. An error occurred.");
           return responseSubjectID;
       }

       closeConnection (con);

        /*** set return values if 1 match was found */
        if (rowCount == 1) {
            SubjectData[] subjects = new SubjectData[1];

            subjects[0] = new SubjectData();
            subjects[0].setSubjectKey("");
            clinicalData.setSubjectData(subjects);

            StudyEventData event = new StudyEventData();
            event.setStudyEventOID("E.01");
            subjects[0].setStudyEventData(new StudyEventData[] { event });

            FormData form = new FormData();
            form.setFormOID("F.01");
            event.setFormData(new FormData[] { form });

            ItemGroupData ig = new ItemGroupData();
            ig.setItemGroupOID("IG.01");
            ig.setItemData(itemsOut);
            form.setItemGroupData(new ItemGroupData[] { ig });

            msg.set_value("SubjectData retrieved successfully.");
            responseSubjectID.setMessage(new Message[] { msg });
            responseSubjectID.setResponseCode(ResponseSubjectIDResponseCode.Retrieved);
        }

        return responseSubjectID;
    }
    /*********************************************************************************************************/

    public ResponseSubjectID isSubjectIDValid(RequestSubjectID responseSubjectID) throws java.rmi.RemoteException
    {
        getConfig(configfile, config);

        /*** set default values */

	String pid = responseSubjectID.getValue();
        ResponseSubjectID response = new ResponseSubjectID();
        response.setValue(pid);

        Message msg = new Message();
        response.setMessage(new Message[] { msg });

        //response.setResponseCode(ResponseSubjectIDResponseCode.Invalid); // default: invalid
        //msg.set_value("SubjectID is not valid.");


        /*** query subjectlist database */

        Class driverClass = loadDriver(config.getDbdriver());

        if (driverClass == null) {
            msg.set_value("Sorry. An error occurred.");
            return (response);
        }

        Connection con = connectURL(config.getDburl(), config.getDbuser(),config.getDbpwd());

        int rowCount = 0;

        if (con != null ) {
           String query =  "SELECT pid FROM rec WHERE pid = '" + pid + "' and sub IS NULL";
           ResultSet result = execQuery(con, query);

           if (result != null)
               try {
                   while (result.next())
                       rowCount++;
               } catch (java.sql.SQLException sqlex) {
                   sqlex.printStackTrace();
               }

        } else {
            msg.set_value("Sorry. An error occurred.");
            return response;
        }

        closeConnection (con);

        /*** set output values */

        if (rowCount == 0) {
            response.setResponseCode(ResponseSubjectIDResponseCode.Invalid);
            msg.set_value("SubjectID is not valid.");
        } else if (rowCount == 1) { // only if exactly one match was found
            response.setResponseCode(ResponseSubjectIDResponseCode.Valid);
            msg.set_value("SubjectID is valid.");
        }

        return response;
    }

   /*********************************************************************************************************/
   /* functions
   /*********************************************************************************************************/

   // TODO: use StudyDefinition as defined in Study.OID (e.g. Study.OID="Study.TMF")
   /*** read field mappings as defined in file, store in global HashMap oidRefMap */
   /*** oidRefMap then maps uppercase OID names to database field names           */
    protected void makeOidRefMap (String filename) {

      try {

	BufferedReader studyReader = new BufferedReader(new FileReader(filename));
	String line;

	while ((line = studyReader.readLine()) != null) {
	  StringTokenizer tok = new StringTokenizer(line, ",");
	  String oid = tok.nextToken().trim().toUpperCase();
	  String value = tok.nextToken().trim();
	  this.oidRefMap.put(oid, value);
	}
      } catch (IOException io) {
	io.printStackTrace();
      }
    }
    /*********************************************************************************************************/

   // TODO: use StudyDefinition as defined in Study.OID (e.g. Study.OID="Study.TMF")
   /*** read field mappings as defined in file, store in global Array fields                */
   /*** fields then contains arrays of OID names and database field names in correct order */
    protected void makeFieldArray (String filename) {

      try {

        BufferedReader studyReader = new BufferedReader(new FileReader(filename));
        String line;
        int i = 0;

        while ((line = studyReader.readLine()) != null) {
          StringTokenizer tok = new StringTokenizer(line, ",");
          String[] array = new String[2];
          array[0] = tok.nextToken().trim();
          array[1] = tok.nextToken().trim();
          this.fields.add(i,array);
          i++;
        }
      } catch (IOException io) {
        io.printStackTrace();
      }
    }
   /*********************************************************************************************************/

   /*** read configuration options from configfile and store values in config container */
    protected void getConfig (String configfile, ConfigHolder config) {

	try {
	  BufferedReader configReader = new BufferedReader(new FileReader(configfile));
	  String line;

	  while ((line = configReader.readLine()) != null) {
	    StringTokenizer tok = new StringTokenizer(line, "=");
	    String name = tok.nextToken().trim();
	    String value="";

	    if ( tok.hasMoreTokens()) {
	    	value = tok.nextToken().trim();
		while (tok.hasMoreTokens())
		   value = value+"="+tok.nextToken();

		value = value.substring(1, (value.length()-1) );
	    }
	    if ( name.equals("psx_cgi_url") )
	      config.setUrl(value);
	    else if (name.equals("field_map") )
	      config.setMappingFile(value);
            else if (name.equals("DBUrl"))
              config.setDburl(value);
            else if (name.equals("DBUser"))
              config.setDbuser(value);
            else if (name.equals("DBPwd"))
              config.setDbpwd(value);
            else if (name.equals("DBDriver"))
              config.setDbdriver(value);
            else if (name.equals("field_sex"))
              config.setFsex(value);
            else if (name.equals("decomp_birthdate"))
              config.setDecompBirthdate(value);
          }
        } catch (IOException io) {
	  io.printStackTrace();
        }
    }
   /*********************************************************************************************************/

   /*** call psx cgi interface at url, store result in psx result container */
    protected void callPSX (String url, PsxDataHolder psx) {

	BufferedReader urlInput;
	DataOutputStream urlOutput;
	URL cgiUrl;
	HttpURLConnection cgiConnection;

	try {
	    cgiUrl = new URL(url);

	   try{
	      cgiConnection = (HttpURLConnection)cgiUrl.openConnection();
	      cgiConnection.setDoOutput(true);
	      cgiConnection.setRequestMethod("POST");
	      urlOutput = new DataOutputStream(cgiConnection.getOutputStream());

	      // write cgi request
	      Iterator keyIterator = valueMap.keySet().iterator();

	      while (keyIterator.hasNext()) {
		String key = (String) keyIterator.next();
		urlOutput.writeBytes("fld_"+key+"="+ (String) valueMap.get(key)+"&");
	      }

	      urlOutput.writeBytes("cmd=Send\r\n\r\n");
	      urlOutput.close();

	      urlInput = new BufferedReader(new InputStreamReader(cgiConnection.getInputStream()));

	      // read cgi response
	      String line;

	      while ((line = urlInput.readLine()) != null) {
	      	StringTokenizer linetok = new StringTokenizer(line, ":");
		psx.setCode(linetok.nextToken());

		if (linetok.hasMoreTokens())
			psx.setPid(linetok.nextToken());

		if (linetok.hasMoreTokens())
			psx.setMessage(linetok.nextToken());

		while (linetok.hasMoreTokens()) {
		   psx.setMessage(psx.getMessage()+":"+linetok.nextToken());
		}
	      }
	      urlInput.close();
	   }
	   catch (IOException ex) {
	   	psx.setMessage(ex.getMessage());
	   	ex.printStackTrace();
	   }
	}
	catch (MalformedURLException e) {
	   e.printStackTrace();
	}
    }
   /*********************************************************************************************************/

   /*** convert OID encoding to psx encoding of sex ( 1 -> M; 2 -> F; else -> N) */
   protected void encodeSex () {
	if ( ( (String) valueMap.get("Geschlecht")).equals("1") ) {
		valueMap.put("Geschlecht", "M");  // male
	} else if ( ( (String) valueMap.get("Geschlecht")).equals("2") ) {
		valueMap.put("Geschlecht", "F");  // female
	} else {
		valueMap.put("Geschlecht", "N");  // not known
	}
    }
   /*********************************************************************************************************/
   /*** convert psx encoding to OID encoding of sex ( M -> 1; F -> 2; else -> 3) */
   protected void decodeSex () {
        if ( ( (String) valueMap.get(config.getFsex())).equals("M") ) {
                valueMap.put(config.getFsex(), "1");  // male
        } else if ( ( (String) valueMap.get(config.getFsex())).equals("F") ) {
                valueMap.put(config.getFsex(), "2");  // female
        } else {
                valueMap.put(config.getFsex(), "3");  // not known
        }
    }
   /*********************************************************************************************************/

   /*** split birthdate into components day, month and year          */
   /*** only applicable if OID name matches "Geburtsdatum"           */
   /*** and fields match "Geburtstag", "Geburtsmonat", "Geburtsjahr" */
   /*** decprecated since psx version 1.1 implements datatype DATE   */
   protected void decomposeBirthdate() {

	String gebTag = "";
	String gebMonat = "";
	String gebJahr = "";

	if ( ((String) valueMap.get("Geburtsdatum")).length() == 10) {
	   gebTag = ((String) valueMap.get("Geburtsdatum")).substring(8,10);
	   gebMonat = ((String) valueMap.get("Geburtsdatum")).substring(5,7);
	   gebJahr = ((String) valueMap.get("Geburtsdatum")).substring(0,4);
	}

	valueMap.put("Geburtstag", gebTag);
	valueMap.put("Geburtsmonat", gebMonat);
	valueMap.put("Geburtsjahr", gebJahr);
	valueMap.remove("Geburtsdatum");
    }
   /*********************************************************************************************************/

   /*** convert sureness encoding ( "+" ->1; "-" -> 0) */
    protected void encodeSureness(String sur) {
	if (sur.equals("+")) {
		valueMap.put("sur", "1");
	} else {
            valueMap.put("sur", "0");
        }
    }
   /*********************************************************************************************************/

   /*** get fields form result set and store in corresponding items (names and values) */
   protected int matchResults( ResultSet result, ItemData[] itemsOut) {

          try {
               int rowCount = 0;
               ResultSetMetaData resultMD = result.getMetaData();

               while (result.next()) {
                  rowCount++;

                  /*** fill in value map: values mapped to OID item names */
                  Iterator fIter = fields.iterator();

                  while (fIter.hasNext()) {
                    String val;
                    String val2 = null; // second component
                    String val3 = null; // third component
                    boolean components = false; // default: only one component

                    String[] fieldRef = (String[]) fIter.next();  // contains OID item name and name of corresponding db field
                    String OID = fieldRef[0]; // OID item name

                    try {
                        val = result.getString("f_" + fieldRef[1]); // get value of db field
                    } catch (Exception e) { // field does not exist -> check whether field is decomposed

                        try {
                            val = result.getString("f_" + fieldRef[1] + "_c1"); // get value of first component
                            val2 = result.getString("f_" + fieldRef[1] + "_c2");
                            val3 = result.getString("f_" + fieldRef[1] + "_c3");
                            components = true;
                        } catch (Exception e2) { // no, components do not exist either
                            val = null; // field does not exist, neither do components
                        }
                    }

                    if (val == null) {
                        valueMap.put(OID, "");
                    } else {
                        if (components) {
                            if (val2 != null)
                                val = val + " " + val2;
                            if (val3 != null)
                                    val = val + " " + val3;
                        }
                        valueMap.put(OID, val);
                    }
                  }

                  /*** get birthdate components and concatenate to date */
                  if (valueMap.get("Geburtsdatum") == null || valueMap.get("Geburtsdatum").equals("") ) { // birthdate not set yet -> look for componetns

                      String gebdate, day, month, year;
                      try {
                          day = result.getString("f_geburtstag");
                          if ( day.length() < 2)
                              day = "0" + day;
                          month = result.getString("f_geburtsmonat");
                          if (month.length() < 2)
                              month = "0" + month;
                          year =  result.getString("f_geburtsjahr");
                          gebdate = year + "-" + month + "-" + day;
                      } catch (Exception e3) {
                          gebdate = "";
                          e3.printStackTrace();
                      }
                      valueMap.put("Geburtsdatum", gebdate);
                  }

                  /*** get sex and encode */
                  if (valueMap.get(config.getFsex()) != null) // sex must be set, else field "geschlecht" does not exist
                      decodeSex();

                  /*** fill in itemsOut: array containing item OID and values*/
                  Iterator fieldsIter = fields.iterator();

                  for (int k = 0; k < fields.size(); k++) {
                      String[] farray = (String[]) fieldsIter.next();  // contains OID item name and name of corresponding db field
                      itemsOut[k] = new ItemData();
                      itemsOut[k].setItemOID(farray[0]);
                      itemsOut[k].setValue((String) valueMap.get(farray[0])); // get value that corresponds to OID item name
                   }

               } // end while
               return ( rowCount);
          } catch (SQLException sqle) {
             sqle.printStackTrace();
             return ( 0 );
          }
    }
  /*********************************************************************************************************/

    static Class loadDriver (String driverName) {
       try {
          return (Class.forName(driverName));
        } catch (ClassNotFoundException e) {
           System.err.println("Can't load driver - " + e.getMessage());
           return (null);
        }
    }
   /*********************************************************************************************************/

    static Connection connectURL (String url, String user, String password) {
       try {
          return (DriverManager.getConnection(url, user, password));
        } catch (SQLException e) {
           System.err.println("Can't connect - "+ e.getMessage());
           return (null);
        }
    }
   /*********************************************************************************************************/

    static void closeConnection (Connection con) {
       try {
          con.close();
        } catch (SQLException e) {
           System.err.println("Can't close connection - "+ e.getMessage());
        }
    }
   /*********************************************************************************************************/

    static ResultSet execQuery (Connection con, String query) {
       try {
          Statement stmt = con.createStatement();
          return ( stmt.executeQuery( query ));
        } catch (SQLException e) {
           System.err.println("Query failed - "+ e.getMessage());
           return (null);
        }
    }
   /*********************************************************************************************************/

    private void jbInit() throws Exception {
    }
   /*********************************************************************************************************/
}
